/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta.mysql;

import com.agimatec.sql.meta.CatalogDescription;
import com.agimatec.sql.meta.ColumnDescription;
import com.agimatec.sql.meta.checking.DatabaseSchemaChecker;
import com.agimatec.sql.meta.mysql.MySqlJdbcMetaFactory;
import com.agimatec.sql.meta.script.DDLExpressions;
import com.agimatec.sql.meta.script.DDLScriptSqlMetaFactory;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.lang.ArrayUtils;

public class MySqlSchemaChecker
extends DatabaseSchemaChecker {
    public void assertObjectsValid() throws Exception {
    }

    protected DDLScriptSqlMetaFactory getDDLScriptSqlMetaFactory() {
        return new DDLScriptSqlMetaFactory(DDLExpressions.forDbms("mysql"));
    }

    protected CatalogDescription readDatabaseCatalog(String[] tableNames) throws SQLException, IOException {
        MySqlJdbcMetaFactory factory = new MySqlJdbcMetaFactory(this.getDatabase());
        return factory.buildCatalog(tableNames);
    }

    protected boolean isPrecisionCompatible(ColumnDescription expected, ColumnDescription actual) {
        int xmlPrecision = expected.getPrecision();
        if (xmlPrecision == 0 && "INT".equalsIgnoreCase(expected.getTypeName())) {
            xmlPrecision = 11;
        } else if (xmlPrecision == 0 && "INT UNSIGNED".equalsIgnoreCase(expected.getTypeName())) {
            xmlPrecision = 10;
        } else if (xmlPrecision == 0 && "BIGINT".equalsIgnoreCase(expected.getTypeName())) {
            xmlPrecision = 20;
        } else if (xmlPrecision == 0 && "SMALLINT".equalsIgnoreCase(expected.getTypeName())) {
            xmlPrecision = 6;
        } else if (xmlPrecision == 0 && "DOUBLE".equalsIgnoreCase(expected.getTypeName())) {
            xmlPrecision = 22;
        } else if (xmlPrecision == 0 && "TEXT".equalsIgnoreCase(expected.getTypeName())) {
            xmlPrecision = 65535;
        } else if (xmlPrecision == 0 && "MEDIUMTEXT".equalsIgnoreCase(expected.getTypeName())) {
            xmlPrecision = 0xFFFFFF;
        } else if (xmlPrecision == 0 && "MEDIUMBLOB".equalsIgnoreCase(expected.getTypeName())) {
            xmlPrecision = 0xFFFFFF;
        } else if (xmlPrecision == 0 && "BLOB".equalsIgnoreCase(expected.getTypeName())) {
            xmlPrecision = 65535;
        } else if (xmlPrecision == 0 && "FLOAT".equalsIgnoreCase(expected.getTypeName())) {
            xmlPrecision = 12;
        } else if (xmlPrecision == 0 && "LONGBLOB".equalsIgnoreCase(expected.getTypeName())) {
            xmlPrecision = Integer.MAX_VALUE;
        }
        return xmlPrecision == actual.getPrecision() || ArrayUtils.contains((Object[])MySqlJdbcMetaFactory.NUM_TYPES, (Object)actual.getTypeName().toUpperCase()) && actual.getPrecision() > xmlPrecision;
    }
}

