/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbmigrate.util;

import com.agimatec.dbmigrate.HaltedException;
import com.agimatec.dbmigrate.util.DBVersionMeta;
import com.agimatec.dbmigrate.util.UpdateVersionScriptVisitor;
import com.agimatec.jdbc.JdbcDatabase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusyLocker {
    protected final String BUSY_VERSION = "busy";
    protected static final Logger log = LoggerFactory.getLogger(BusyLocker.class);
    private int maxAttempts = -1;
    private int delayBetweenAttempts = 10000;
    protected boolean ownLock = false;

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public int getDelayBetweenAttempts() {
        return this.delayBetweenAttempts;
    }

    public void setDelayBetweenAttempts(int delayBetweenAttempts) {
        this.delayBetweenAttempts = delayBetweenAttempts;
    }

    public boolean isEnabled(DBVersionMeta dbVersionMeta) {
        return dbVersionMeta.getLockBusy() != null && dbVersionMeta.getLockBusy() != DBVersionMeta.LockBusy.No;
    }

    public void lockBusy(DBVersionMeta dbVersionMeta, JdbcDatabase database) {
        block5: {
            if (dbVersionMeta.getLockBusy() == DBVersionMeta.LockBusy.No) {
                return;
            }
            if (dbVersionMeta.isInsertOnly()) {
                throw new UnsupportedOperationException("not yet implemented: insertOnly + lock-busy");
            }
            try {
                this.tryLock(dbVersionMeta, database);
            }
            catch (SQLException ex) {
                if (dbVersionMeta.getLockBusy() == DBVersionMeta.LockBusy.Fail) {
                    this.fail(dbVersionMeta, ex);
                }
                if (dbVersionMeta.getLockBusy() != DBVersionMeta.LockBusy.Wait) break block5;
                this.waitAndRetry(dbVersionMeta, database, 1, ex);
            }
        }
    }

    private void lockAll(DBVersionMeta dbVersionMeta, JdbcDatabase database) throws SQLException {
        PreparedStatement stmt = database.getConnection().prepareStatement(dbVersionMeta.toSQLLockAll());
        stmt.execute();
        stmt.close();
    }

    private int countBusy(DBVersionMeta dbVersionMeta, JdbcDatabase database) throws SQLException {
        PreparedStatement stmt = database.getConnection().prepareStatement(dbVersionMeta.toSQLCountVersion());
        stmt.setString(1, "busy");
        ResultSet resultSet = stmt.executeQuery();
        resultSet.next();
        int count = resultSet.getInt(1);
        resultSet.close();
        stmt.close();
        return count;
    }

    private void tryLock(DBVersionMeta dbVersionMeta, JdbcDatabase database) throws SQLException {
        int count = UpdateVersionScriptVisitor.insertVersion(database, "busy", dbVersionMeta);
        if (count != 1) {
            log.warn(dbVersionMeta.toSQLInsert() + " for busy-lock '" + "busy" + "' affected " + count + " rows!");
        } else {
            log.info("Required busy-lock 'busy' on table " + dbVersionMeta.getTableName());
            this.setOwnLock(true);
        }
    }

    public boolean isOwnLock() {
        return this.ownLock;
    }

    public void setOwnLock(boolean ownLock) {
        this.ownLock = ownLock;
    }

    private void fail(DBVersionMeta dbVersionMeta, SQLException ex) {
        throw new HaltedException("Could not require busy-lock 'busy' from table '" + dbVersionMeta.getTableName() + "'. " + "Perhaps another instance of dbmigrate is currently running on the database or " + "the lock was not correctly removed from a previous execution of dbmigrate. " + "\nTo remove the lock, execute: " + "DELETE FROM " + dbVersionMeta.getTableName() + " WHERE " + dbVersionMeta.getColumn_version() + " = '" + "busy" + "';", ex);
    }

    private void waitAndRetry(DBVersionMeta dbVersionMeta, JdbcDatabase database, int attempt, SQLException ex) {
        while (this.maxAttempts < 0 || attempt < this.maxAttempts) {
            log.warn("Attempt " + attempt + " to require busy-lock failed. Waiting for " + this.delayBetweenAttempts + " millis to retry...", (Throwable)ex);
            if (this.delayBetweenAttempts > 0) {
                try {
                    Thread.sleep(this.delayBetweenAttempts);
                }
                catch (InterruptedException e) {
                    log.warn("Interrupted while waiting for retry", (Throwable)e);
                }
            }
            try {
                this.tryLock(dbVersionMeta, database);
                return;
            }
            catch (SQLException e) {
                ex = e;
                ++attempt;
            }
        }
        this.fail(dbVersionMeta, ex);
    }

    public void unlockBusy(DBVersionMeta dbVersionMeta, JdbcDatabase database) {
        if (dbVersionMeta.getLockBusy() == DBVersionMeta.LockBusy.No) {
            return;
        }
        if (!this.isOwnLock()) {
            log.info("Not deleting lock 'busy' on table " + dbVersionMeta.getTableName() + " because this instance does not own it.");
        } else {
            try {
                int count = UpdateVersionScriptVisitor.deleteVersion(database, "busy", dbVersionMeta);
                if (count != 1) {
                    log.warn(dbVersionMeta.toSQLDelete() + " for busy-lock '" + "busy" + "' affected " + count + " rows!");
                } else {
                    log.info("Deleted busy-lock 'busy' on table " + dbVersionMeta.getTableName());
                    this.setOwnLock(false);
                }
            }
            catch (SQLException e) {
                log.error("Failed to delete busy-lock", (Throwable)e);
            }
        }
    }
}

