/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta.script;

import com.agimatec.sql.meta.script.A_ExtractPart;
import com.agimatec.sql.meta.script.ExtractExpr;
import com.agimatec.sql.meta.script.RevertableStringTokenizer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class PropertiesExtractor {
    private String delim;
    private String text;
    private HashMap properties;
    private RevertableStringTokenizer tokens;
    private String token;
    Map current;

    public PropertiesExtractor() {
        this.delim = ",() \t";
    }

    public PropertiesExtractor(String aDelim) {
        this.delim = aDelim;
    }

    public void close() {
        this.current = null;
        this.properties = null;
        this.token = null;
        this.tokens = null;
        this.text = null;
    }

    public Map extract(String aText, ExtractExpr aExpr) {
        this.text = aText;
        this.properties = new HashMap();
        this.tokens = new RevertableStringTokenizer(new StringTokenizer(this.text, this.delim, true));
        this.current = this.properties;
        this.token = null;
        int result = this.process(aExpr);
        return result == 0 || result == -1 ? null : this.properties;
    }

    public Map getProperties() {
        return this.properties;
    }

    int process(ExtractExpr aExpr) {
        Iterator parts = aExpr.parts();
        int repeatResult = 3;
        do {
            if (repeatResult == 0) {
                return 0;
            }
            A_ExtractPart part = null;
            boolean concatMode = false;
            block12: while ((this.token != null || this.tokens.hasMoreTokens()) && (parts.hasNext() || part != null)) {
                int result;
                boolean isDelim;
                if (this.token == null) {
                    this.token = this.tokens.nextToken();
                }
                if (concatMode) {
                    this.token = this.token + this.tokens.nextToken();
                }
                if (part == null) {
                    part = (A_ExtractPart)parts.next();
                }
                boolean bl = isDelim = this.delim.indexOf(this.token) >= 0;
                if (isDelim) {
                    if (!this.token.equals(" ")) {
                        result = part.fits(this.token);
                        switch (result) {
                            case -1: 
                            case 0: {
                                return result;
                            }
                            case 1: {
                                part = null;
                                this.token = null;
                                break;
                            }
                            case 3: {
                                isDelim = false;
                                break;
                            }
                        }
                    } else {
                        this.token = null;
                    }
                }
                if (isDelim) continue;
                result = part.process(this.token, this);
                switch (result) {
                    case 0: {
                        return 0;
                    }
                    case -1: 
                    case 1: {
                        part = null;
                        this.token = null;
                        concatMode = false;
                        continue block12;
                    }
                    case 2: {
                        concatMode = true;
                        continue block12;
                    }
                    case 3: {
                        part = null;
                        concatMode = false;
                        continue block12;
                    }
                }
                throw new IllegalStateException("internal error: " + result);
            }
            if (parts.hasNext() || part != null) {
                if (part == null) {
                    part = (A_ExtractPart)parts.next();
                }
                while (part != null) {
                    if (!part.isOptional()) {
                        return 0;
                    }
                    part = parts.hasNext() ? (A_ExtractPart)parts.next() : null;
                }
                return 1;
            }
            if (!aExpr.isRepeating()) continue;
            parts = aExpr.parts();
            if (this.token != null && this.delim.indexOf(this.token) == -1) {
                this.token = null;
            }
            do {
                if (this.token == null && this.tokens.hasMoreTokens()) {
                    this.token = this.tokens.nextToken();
                }
                if (!" ".equals(this.token)) continue;
                this.token = null;
            } while (this.token == null && this.tokens.hasMoreTokens());
            repeatResult = aExpr.prepareLoop(this.token, this);
            if (repeatResult != 1) continue;
            this.token = null;
        } while (repeatResult == 1 || repeatResult == 2);
        if (repeatResult == -1) {
            repeatResult = 3;
        }
        return repeatResult;
    }

    protected RevertableStringTokenizer getTokens() {
        return this.tokens;
    }

    protected void setToken(String token) {
        this.token = token;
    }
}

