/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta.script;

import com.agimatec.commons.config.MapNode;
import com.agimatec.dbmigrate.action.ScriptAction;
import com.agimatec.sql.meta.CatalogDescription;
import com.agimatec.sql.meta.ColumnDescription;
import com.agimatec.sql.meta.ForeignKeyDescription;
import com.agimatec.sql.meta.IndexDescription;
import com.agimatec.sql.meta.SequenceDescription;
import com.agimatec.sql.meta.SqlMetaFactory;
import com.agimatec.sql.meta.TableDescription;
import com.agimatec.sql.meta.script.DDLExpressions;
import com.agimatec.sql.meta.script.ExtractExpr;
import com.agimatec.sql.meta.script.ExtractExprBuilder;
import com.agimatec.sql.meta.script.PropertiesExtractor;
import com.agimatec.sql.script.SQLScriptParser;
import com.agimatec.sql.script.ScriptVisitor;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDLScriptSqlMetaFactory
implements SqlMetaFactory,
ScriptVisitor {
    private static final Logger log = LoggerFactory.getLogger(DDLScriptSqlMetaFactory.class);
    private CatalogDescription catalog;
    private final PropertiesExtractor extractor;
    private final Map<String, CatalogBuilder> builders = new HashMap<String, CatalogBuilder>();
    private final DDLExpressions ddlSpec;

    public DDLScriptSqlMetaFactory(DDLExpressions ddlSpecification) {
        this.init();
        this.ddlSpec = ddlSpecification;
        if (this.ddlSpec.getExpressions() == null) {
            throw new IllegalStateException("DDL class not ready - initialization failed");
        }
        this.extractor = new PropertiesExtractor();
        if (log.isDebugEnabled()) {
            log.debug("using " + ddlSpecification);
        }
    }

    protected void init() {
        this.builders.put("table-add-columns", new TableAddColumnsBuilder());
        this.builders.put("table-alter-columns", new TableAlterColumnsBuilder());
        this.builders.put("table-add-constraint", new TableAddConstraintBuilder());
        this.builders.put("create-index", new CreateIndexBuilder());
        this.builders.put("table-add-foreign-key", new TableAddForeignKeyBuilder());
        this.builders.put("create-sequence", new CreateSequenceBuilder());
        this.builders.put("create-table", new CreateTableBuilder());
        this.builders.put("drop-table", new DropTableBuilder());
        this.builders.put("drop-sequence", new DropSequenceBuilder());
        this.builders.put("dezign-create-table", new DezignCreateTableBuilder());
        this.builders.put("table-add-primary-key", new TableAddPrimaryKey());
        this.builders.put("table-comment", new TableCommentBuilder());
        this.builders.put("column-comment", new ColumnCommentBuilder());
    }

    public static ExtractExpr[] compileExpressions(String[] statementFormats) {
        ExtractExpr[] expressions = new ExtractExpr[statementFormats.length];
        for (int i = 0; i < expressions.length; ++i) {
            String format = statementFormats[i];
            try {
                expressions[i] = ExtractExprBuilder.buildExpr(format);
                continue;
            }
            catch (ParseException e) {
                log.error("cannot initialize expression: " + format, (Throwable)e);
                return null;
            }
        }
        return expressions;
    }

    protected Map<String, CatalogBuilder> getBuilders() {
        return this.builders;
    }

    protected DDLExpressions getDdlSpec() {
        return this.ddlSpec;
    }

    protected PropertiesExtractor getExtractor() {
        return this.extractor;
    }

    public CatalogDescription getCatalog() {
        if (this.catalog == null) {
            this.setCatalog(new CatalogDescription());
        }
        return this.catalog;
    }

    public void setCatalog(CatalogDescription aCatalog) {
        this.catalog = aCatalog;
    }

    public void fillCatalog(URL scriptURL, ScriptAction.FileFormat fileFormat) throws SQLException, IOException {
        SQLScriptParser parser = new SQLScriptParser(log);
        if (fileFormat == null || fileFormat.equals((Object)ScriptAction.FileFormat.SQL)) {
            parser.iterateSQLScript((ScriptVisitor)this, scriptURL);
        } else if (fileFormat.equals((Object)ScriptAction.FileFormat.JDBC)) {
            parser.iterateSQLLines((ScriptVisitor)this, scriptURL);
        } else if (fileFormat.equals((Object)ScriptAction.FileFormat.STMT)) {
            parser.execSQLScript((ScriptVisitor)this, scriptURL);
        } else {
            throw new UnsupportedOperationException(scriptURL + "is not a supported file type: " + (Object)((Object)fileFormat));
        }
    }

    public void fillCatalog(URL scriptURL) throws SQLException, IOException {
        this.fillCatalog(scriptURL, null);
    }

    @Override
    public int visitStatement(String statement) throws SQLException {
        int found = 0;
        for (ExtractExpr theExpr : this.ddlSpec.getExpressions()) {
            CatalogBuilder builder;
            Map values = this.extractor.extract(statement, theExpr);
            if (values == null) continue;
            ++found;
            if (log.isDebugEnabled()) {
                log.debug("FOUND " + theExpr.getName() + " in: " + statement);
                log.debug(String.valueOf(values));
            }
            if ((builder = this.builders.get(theExpr.getName())) == null) break;
            try {
                builder.process(new MapNode(values), this.getCatalog());
            }
            catch (Exception e) {
                log.error("error processing " + values, (Throwable)e);
            }
            break;
        }
        if (found == 0 && log.isDebugEnabled()) {
            log.debug("IGNORE: " + statement);
        }
        return 0;
    }

    @Override
    public void visitComment(String theComment) throws SQLException {
    }

    @Override
    public void doCommit() throws SQLException {
    }

    @Override
    public void doRollback() throws SQLException {
    }

    class TableAddPrimaryKey
    extends CatalogBuilder {
        TableAddPrimaryKey() {
        }

        public void process(MapNode values, CatalogDescription catalog) {
            TableDescription td = this.getTable(catalog, values.getString("table"));
            IndexDescription pk = new IndexDescription();
            pk.setTableName(this.strip(td.getTableName()));
            pk.setTableSpace(this.strip(values.getString("constraint/tableSpace/tableSpace")));
            pk.setIndexName(this.strip(values.getString("constraint/constraintName")));
            pk.setUnique(true);
            List columns = values.getList("constraint/columns");
            for (Object column : columns) {
                Map eachCol = (Map)column;
                pk.addColumn(this.strip((String)eachCol.get("column")));
            }
            td.setPrimaryKey(pk);
        }
    }

    protected class DezignCreateTableBuilder
    extends CreateTableBuilder {
        protected DezignCreateTableBuilder() {
        }

        public void process(MapNode values, CatalogDescription catalog) throws IOException, TemplateException {
            super.process(values, catalog);
            String tableName = this.strip(values.getString("table"));
            TableDescription td = this.getTable(catalog, tableName);
            List elements = values.getList("tableElement");
            for (Object element : elements) {
                MapNode theColDef = new MapNode((Map)element);
                if (theColDef.getMap().containsKey("tableConstraint")) {
                    this.buildTableConstraint(theColDef, td);
                }
                if (theColDef.getMap().containsKey("tableIndex")) {
                    this.buildTableIndex(theColDef, td);
                }
                if (theColDef.getString("columndefinition/isUnique") == null) continue;
                IndexDescription index = new IndexDescription();
                index.setTableName(td.getTableName());
                index.addColumn(this.strip(theColDef.getString("columndefinition/column")));
                index.setUnique(true);
                td.addIndex(index);
            }
        }

        protected void buildTableConstraint(MapNode aColDef, TableDescription aTd) {
            IndexDescription index = new IndexDescription();
            index.setTableName(aTd.getTableName());
            index.setTableSpace(this.strip(aColDef.getString("tableConstraint/tableSpace/tableSpace")));
            index.setIndexName(this.strip(aColDef.getString("tableConstraint/constraint/constraintName")));
            List columns = aColDef.getList("tableConstraint/columns");
            for (Object column : columns) {
                Map eachCol = (Map)column;
                index.addColumn(this.strip((String)eachCol.get("column")));
            }
            if (aColDef.getString("tableConstraint/isPK") != null) {
                index.setUnique(true);
                aTd.setPrimaryKey(index);
            } else {
                if (aColDef.getString("tableConstraint/isUnique") != null) {
                    index.setUnique(true);
                }
                aTd.addConstraint(index);
            }
        }

        protected void buildTableIndex(MapNode aColDef, TableDescription aTd) {
            IndexDescription index = new IndexDescription();
            index.setTableName(aTd.getTableName());
            index.setTableSpace(this.strip(aColDef.getString("tableIndex/tableSpace/tableSpace")));
            index.setIndexName(this.strip(aColDef.getString("tableIndex/indexName")));
            if (index.getIndexName() == null) {
                index.setIndexName(this.strip(aColDef.getString("tableIndex/optional/indexName")));
            }
            List columns = aColDef.getList("tableIndex/columns");
            for (Object column : columns) {
                Map eachCol = (Map)column;
                index.addColumn(this.strip((String)eachCol.get("column")));
            }
            if (aColDef.getString("tableIndex/isPK") != null) {
                index.setUnique(true);
                aTd.setPrimaryKey(index);
            } else {
                if (aColDef.getString("tableIndex/isUnique") != null) {
                    index.setUnique(true);
                }
                aTd.addIndex(index);
            }
        }
    }

    class CreateTableBuilder
    extends CatalogBuilder {
        CreateTableBuilder() {
        }

        public void process(MapNode values, CatalogDescription catalog) throws IOException, TemplateException {
            String tableName = this.strip(values.getString("table"));
            TableDescription td = this.getTable(catalog, tableName);
            List elements = values.getList("tableElement");
            for (Object element : elements) {
                MapNode theColDef = new MapNode((Map)element);
                if (theColDef.getMap().containsKey("columndefinition")) {
                    this.buildColumnDescription(new MapNode((Map)theColDef.get("columndefinition")), td);
                    continue;
                }
                if (theColDef.getMap().containsKey("primaryKey")) {
                    this.buildPrimaryKey(theColDef, td);
                    continue;
                }
                if (!theColDef.getMap().containsKey("foreignKey")) continue;
                this.buildForeignKey(theColDef, td);
            }
        }

        protected void buildForeignKey(MapNode aColDef, TableDescription aTd) {
            ForeignKeyDescription fk = new ForeignKeyDescription();
            fk.setTableName(aTd.getTableName());
            fk.setConstraintName(this.strip(aColDef.getString("foreignKey/constraint/constraintName")));
            fk.setRefTableName(this.strip(aColDef.getString("foreignKey/refTable")));
            fk.setTableSpace(this.strip(aColDef.getString("foreignKey/tableSpace/tableSpace")));
            fk.setOnDeleteRule(aColDef.getString("foreignKey/onDeleteRule"));
            List columns = aColDef.getList("foreignKey/columns");
            List refcolumns = aColDef.getList("foreignKey/refcolumns/refcolumns");
            for (int j = 0; j < columns.size(); ++j) {
                Map eachCol = (Map)columns.get(j);
                Map refCol = refcolumns != null ? (Map)refcolumns.get(j) : null;
                fk.addColumnPair(this.strip((String)eachCol.get("column")), refCol != null ? this.strip((String)refCol.get("column")) : null);
            }
            aTd.addForeignKey(fk);
        }

        protected void buildPrimaryKey(MapNode aColDef, TableDescription aTd) {
            IndexDescription pk = new IndexDescription();
            pk.setTableName(aTd.getTableName());
            pk.setTableSpace(this.strip(aColDef.getString("primaryKey/tableSpace/tableSpace")));
            pk.setIndexName(this.strip(aColDef.getString("primaryKey/constraint/constraintName")));
            pk.setUnique(true);
            List columns = aColDef.getList("primaryKey/columns");
            for (Object column : columns) {
                Map eachCol = (Map)column;
                pk.addColumn(this.strip((String)eachCol.get("column")));
            }
            aTd.setPrimaryKey(pk);
        }
    }

    class DropTableBuilder
    extends CatalogBuilder {
        DropTableBuilder() {
        }

        public void process(MapNode values, CatalogDescription catalog) throws IOException, TemplateException {
            String tableName = this.strip(values.getString("table"));
            catalog.removeTable(tableName);
        }
    }

    class CreateSequenceBuilder
    extends CatalogBuilder {
        CreateSequenceBuilder() {
        }

        public void process(MapNode values, CatalogDescription catalog) {
            SequenceDescription sd = new SequenceDescription();
            sd.setSequenceName(this.strip(values.getString("sequence")));
            sd.setCache(this.getInt(values, "attributes/cache/value"));
            sd.setCycle(!this.getBool(values, "attributes/nocycle"));
            sd.setIncrement(this.getInt(values, "attributes/increment"));
            if (sd.getIncrement() == 0) {
                sd.setIncrement(1);
            }
            sd.setStart(this.getInt(values, "attributes/start"));
            if (sd.getStart() == 0L) {
                sd.setStart(1L);
            }
            sd.setOrder(!this.getBool(values, "attributes/noorder"));
            catalog.addSequence(sd);
        }
    }

    class DropSequenceBuilder
    extends CatalogBuilder {
        DropSequenceBuilder() {
        }

        public void process(MapNode values, CatalogDescription catalog) throws IOException, TemplateException {
            String seqName = values.getString("sequence");
            catalog.removeSequence(seqName);
        }
    }

    class TableAddForeignKeyBuilder
    extends CatalogBuilder {
        TableAddForeignKeyBuilder() {
        }

        public void process(MapNode values, CatalogDescription catalog) {
            ForeignKeyDescription fk = new ForeignKeyDescription();
            fk.setTableName(this.strip(values.getString("table")));
            fk.setConstraintName(this.strip(values.getString("constraint/constraintName")));
            fk.setRefTableName(this.strip(values.getString("constraint/refTable")));
            fk.setTableSpace(this.strip(values.getString("tableSpace/tableSpace")));
            fk.setOnDeleteRule(values.getString("constraint/onDeleteRule"));
            List columns = values.getList("constraint/columns");
            List refcolumns = values.getList("constraint/refcolumns/refcolumns");
            for (int i = 0; i < columns.size(); ++i) {
                Map eachCol = (Map)columns.get(i);
                Map refCol = refcolumns != null ? (Map)refcolumns.get(i) : null;
                fk.addColumnPair(this.strip((String)eachCol.get("column")), refCol != null ? this.strip((String)refCol.get("column")) : null);
            }
            TableDescription td = this.getTable(catalog, fk.getTableName());
            td.addForeignKey(fk);
        }
    }

    class CreateIndexBuilder
    extends CatalogBuilder {
        CreateIndexBuilder() {
        }

        public void process(MapNode values, CatalogDescription catalog) {
            IndexDescription id = new IndexDescription();
            id.setTableName(this.strip(values.getString("table")));
            id.setTableSpace(this.strip(values.getString("tableSpace/tableSpace")));
            id.setIndexName(this.strip(values.getString("indexName")));
            id.setUnique(this.getBool(values, "unique"));
            List columns = values.getList("columns");
            for (Object column : columns) {
                Map eachCol = (Map)column;
                id.addColumn(this.strip((String)eachCol.get("column")));
                if (id.isFunctionBased()) continue;
                id.setFunctionBased(eachCol.get("func") != null);
            }
            this.getTable(catalog, id.getTableName()).addIndex(id);
        }
    }

    class TableAddConstraintBuilder
    extends CatalogBuilder {
        TableAddConstraintBuilder() {
        }

        public void process(MapNode values, CatalogDescription catalog) {
            IndexDescription id = new IndexDescription();
            id.setTableName(this.strip(values.getString("table")));
            id.setTableSpace(this.strip(values.getString("constraint/tableSpace/tableSpace")));
            id.setIndexName(this.strip(values.getString("constraint/constraintName")));
            id.setUnique(this.getBool(values, "constraint/unique"));
            List columns = values.getList("constraint/columns");
            for (Object column : columns) {
                Map eachCol = (Map)column;
                id.addColumn(this.strip((String)eachCol.get("column")));
            }
            TableDescription td = this.getTable(catalog, id.getTableName());
            td.addConstraint(id);
        }
    }

    class ColumnCommentBuilder
    extends CatalogBuilder {
        ColumnCommentBuilder() {
        }

        public void process(MapNode values, CatalogDescription catalog) {
            String qualifiedColumn = (String)values.get("tableColumn");
            String tableName = qualifiedColumn.substring(0, qualifiedColumn.indexOf(46));
            String columnName = this.strip(qualifiedColumn.substring(tableName.length() + 1));
            TableDescription td = this.getTable(catalog, tableName);
            ColumnDescription col = td.getColumn(columnName);
            if (col == null) {
                col = new ColumnDescription();
                col.setColumnName(columnName);
                td.addColumn(col);
            }
            col.setComment((String)values.get("comment"));
        }
    }

    class TableCommentBuilder
    extends CatalogBuilder {
        TableCommentBuilder() {
        }

        public void process(MapNode values, CatalogDescription catalog) {
            TableDescription td = this.getTable(catalog, values.getString("table"));
            td.setComment((String)values.get("comment"));
        }
    }

    class TableAlterColumnsBuilder
    extends CatalogBuilder {
        TableAlterColumnsBuilder() {
        }

        public void process(MapNode values, CatalogDescription catalog) {
            TableDescription td = this.getTable(catalog, values.getString("table"));
            List columns = values.getList("tableElement");
            for (Object column : columns) {
                ColumnDescription colDef;
                String colName;
                MapNode node;
                Map map = (Map)column;
                if (map.containsKey("add-column")) {
                    this.buildColumnDescription(new MapNode((Map)map.get("add-column")), td);
                    continue;
                }
                if (map.containsKey("alter-column-type")) {
                    node = new MapNode((Map)map.get("alter-column-type"));
                    colName = this.strip(node.getString("column"));
                    colDef = td.getColumn(colName);
                    this.setColType(node, colDef);
                    continue;
                }
                if (map.containsKey("alter-column-drop-notnull")) {
                    node = new MapNode((Map)map.get("alter-column-drop-notnull"));
                    colName = this.strip(node.getString("column"));
                    colDef = td.getColumn(colName);
                    colDef.setNullable(true);
                    continue;
                }
                if (map.containsKey("alter-column-set-notnull")) {
                    node = new MapNode((Map)map.get("alter-column-set-notnull"));
                    colName = this.strip(node.getString("column"));
                    colDef = td.getColumn(colName);
                    colDef.setNullable(false);
                    continue;
                }
                if (map.containsKey("drop-column")) {
                    String colName2 = this.strip(new MapNode((Map)map.get("add-column")).getString("column"));
                    td.removeColumn(colName2);
                    continue;
                }
                if (map.containsKey("drop-constraint")) {
                    String consName = this.strip(new MapNode((Map)map.get("drop-constraint")).getString("constraintName"));
                    td.removeConstraint(consName);
                    continue;
                }
                if (!map.containsKey("alter-column-drop-notnull")) continue;
                node = new MapNode((Map)map.get("alter-column-drop-notnull"));
                colName = this.strip(node.getString("column"));
                colDef = td.getColumn(colName);
                colDef.setNullable(true);
            }
        }
    }

    class TableAddColumnsBuilder
    extends CatalogBuilder {
        TableAddColumnsBuilder() {
        }

        public void process(MapNode values, CatalogDescription catalog) {
            TableDescription td = this.getTable(catalog, values.getString("table"));
            List columns = values.getList("columndefinition");
            for (Object column : columns) {
                MapNode eachCol = new MapNode((Map)column);
                this.buildColumnDescription(eachCol, td);
            }
        }
    }

    protected abstract class CatalogBuilder {
        protected CatalogBuilder() {
        }

        public abstract void process(MapNode var1, CatalogDescription var2) throws IOException, TemplateException;

        protected String strip(String value) {
            return DDLScriptSqlMetaFactory.this.ddlSpec.strip(value);
        }

        protected String unqualified(String value) {
            int idx = value.lastIndexOf(46);
            if (idx >= 0) {
                return value.substring(idx + 1);
            }
            return value;
        }

        protected int getInt(MapNode values, String path) {
            String s = values.getString(path);
            if (s != null && s.length() > 0) {
                try {
                    return Integer.parseInt(s);
                }
                catch (NumberFormatException ex) {
                    return 0;
                }
            }
            return 0;
        }

        protected boolean getBool(MapNode values, String path) {
            String v = values.getString(path);
            return v != null && v.length() > 0;
        }

        protected ColumnDescription buildColumnDescription(MapNode aColDef, TableDescription aTd) {
            ColumnDescription cd = new ColumnDescription();
            cd.setColumnName(this.strip(aColDef.getString("column")));
            cd.setNullable(!this.getBool(aColDef, "mandatory"));
            cd.setComment((String)aColDef.get("comment"));
            this.setColType(aColDef, cd);
            aTd.addColumn(cd);
            if (aColDef.getString("isPK") != null) {
                IndexDescription pk = aTd.getPrimaryKey();
                if (pk == null) {
                    pk = new IndexDescription();
                    pk.setTableName(aTd.getTableName());
                    pk.setUnique(true);
                    aTd.setPrimaryKey(pk);
                }
                pk.addColumn(cd.getColumnName());
            }
            return cd;
        }

        protected void setColType(MapNode aColDef, ColumnDescription cd) {
            Map precision = aColDef.getMap("precision");
            if (precision != null) {
                cd.setPrecisionEnabled(true);
                List numbers = (List)precision.get("numbers");
                if (numbers.size() > 0) {
                    cd.setPrecision(this.getInt(aColDef, "precision/numbers/0/value"));
                }
                if (numbers.size() > 1) {
                    cd.setScale(this.getInt(aColDef, "precision/numbers/1/value"));
                }
            }
            cd.setTypeName(aColDef.getString("typeName"));
            if (aColDef.getString("unsigned") != null) {
                cd.setTypeName(cd.getTypeName() + " " + aColDef.getString("unsigned"));
            }
            if (aColDef.getString("varying") != null) {
                cd.setTypeName(cd.getTypeName() + " " + aColDef.getString("varying"));
            }
            cd.setDefaultValue(aColDef.getString("default/defaultValue"));
            DDLScriptSqlMetaFactory.this.ddlSpec.equalizeColumn(cd);
        }

        protected TableDescription getTable(CatalogDescription aCatalog, String aTableName) {
            String simpleName = this.unqualified(aTableName);
            TableDescription td = aCatalog.getTable(aTableName);
            if (td == null && !aTableName.equals(simpleName)) {
                td = aCatalog.getTable(simpleName);
            }
            if (td == null) {
                td = new TableDescription();
                td.setTableName(simpleName);
                if (aTableName.contains(".")) {
                    String[] array = aTableName.split("\\.");
                    if (array.length == 2) {
                        td.setCatalogName(array[0]);
                    }
                    if (array.length == 3) {
                        td.setSchemaName(array[0]);
                        td.setCatalogName(array[1]);
                    }
                }
                aCatalog.addTable(td);
            }
            return td;
        }
    }
}

