/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbtransform.ejb3;

import com.agimatec.dbtransform.ejb3.Ejb3Class;
import com.agimatec.dbtransform.ejb3.Ejb3Prototype;
import com.agimatec.sql.meta.CatalogDescription;
import com.agimatec.sql.meta.TableDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3Schema
extends Ejb3Prototype {
    private final CatalogDescription catalog;
    private Map<String, Ejb3Class> ejb3classes;

    public Ejb3Schema(CatalogDescription catalog) {
        this.catalog = catalog;
    }

    public CatalogDescription getCatalog() {
        return this.catalog;
    }

    public void generate() {
        this.ejb3classes = new HashMap<String, Ejb3Class>();
        ArrayList<Ejb3Class> manyToManyLinks = new ArrayList<Ejb3Class>();
        for (TableDescription table : this.catalog.getTables().values()) {
            Ejb3Class ejb3 = new Ejb3Class(table);
            if (!ejb3.isManyToManyLink()) {
                ejb3.generateAttributes();
                this.ejb3classes.put(ejb3.getTable().getTableName(), ejb3);
                continue;
            }
            manyToManyLinks.add(ejb3);
        }
        for (Ejb3Class ejb3 : this.ejb3classes.values()) {
            ejb3.generateRelationships(this);
        }
        for (Ejb3Class ejb3 : manyToManyLinks) {
            ejb3.generateRelationships(this);
        }
    }

    public Map<String, Ejb3Class> getEjb3classes() {
        return this.ejb3classes;
    }

    public Collection<Ejb3Class> getEjb3classesCollection() {
        return this.ejb3classes.values();
    }
}

