/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.commons.config.sax;

import com.agimatec.commons.config.Node;
import com.agimatec.commons.config.sax.ConfigContentHandler;
import com.agimatec.commons.config.sax.ConfigWriter;
import java.io.PrintWriter;
import org.apache.commons.lang.StringEscapeUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class NodeHandler {
    private final String tag;

    public NodeHandler(String aTag) {
        this.tag = aTag;
    }

    protected void acceptNode(ConfigContentHandler docHandler, Object aNode, Attributes attr) throws SAXException {
        throw new SAXException(this.tag() + " cannot have subelements");
    }

    protected String tag() {
        return this.tag;
    }

    protected void acceptCharacters(ConfigContentHandler docHandler, char[] chars, int offset, int length) throws SAXException {
    }

    protected String appendCharacters(String oldText, char[] chars, int offset, int length) {
        String newText = new String(chars, offset, length);
        if (oldText == null) {
            return newText;
        }
        return oldText + newText;
    }

    protected abstract Object startNode(Attributes var1) throws SAXException;

    protected abstract Class getInstanceClass();

    protected void setName(Node node, Attributes attr) {
        node.setName(this.getName(attr));
    }

    protected String getValue(Attributes attr) {
        return attr.getValue("value");
    }

    protected String getName(Attributes attr) {
        return attr.getValue("name");
    }

    protected void writeConfig(ConfigWriter writer, Object obj, Object parent, PrintWriter pw, int indent) throws SAXException {
        Node node = (Node)obj;
        pw.write("<");
        pw.write(this.tag());
        if (node.getName() != null) {
            pw.write(" name=\"");
            pw.write(StringEscapeUtils.escapeXml((String)node.getName()));
            pw.write("\"");
        }
        if (node.getObjectValue() != null) {
            pw.write(" value=\"");
            pw.write(StringEscapeUtils.escapeXml((String)node.getObjectValue().toString()));
            pw.write("\"");
        }
        pw.write("/>");
    }

    protected final void printIndent(PrintWriter pw, int indent) {
        for (int i = 0; i < indent; ++i) {
            pw.write("  ");
        }
    }

    protected void writeParentName(PrintWriter pw, Object parent) {
        if (parent != null && parent instanceof String) {
            pw.write(" name=\"");
            pw.write(StringEscapeUtils.escapeXml((String)((String)parent)));
            pw.write("\"");
        }
    }
}

