/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.commons.config.sax;

import com.agimatec.commons.config.DecimalNode;
import com.agimatec.commons.config.sax.ConfigContentHandler;
import com.agimatec.commons.config.sax.NodeHandler;
import java.math.BigDecimal;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class DecimalNodeHandler
extends NodeHandler {
    public DecimalNodeHandler(String aTag) {
        super(aTag);
    }

    protected Class getInstanceClass() {
        return DecimalNode.class;
    }

    protected void acceptCharacters(ConfigContentHandler docHandler, char[] chars, int offset, int length) throws SAXException {
        DecimalNode node = (DecimalNode)docHandler.getCurrentNode();
        this.setValue(node, new String(chars, offset, length));
    }

    protected Object startNode(Attributes attr) throws SAXException {
        DecimalNode node = new DecimalNode();
        this.setName(node, attr);
        String value = this.getValue(attr);
        if (value != null) {
            try {
                this.setValue(node, value);
            }
            catch (NumberFormatException ex) {
                throw new SAXException("not a BigDecimal: " + value, ex);
            }
        }
        return node;
    }

    private void setValue(DecimalNode node, String stringValue) {
        node.setValue(new BigDecimal(stringValue));
    }
}

