/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.commons.config.sax;

import com.agimatec.commons.config.Config;
import com.agimatec.commons.config.ConfigManager;
import com.agimatec.commons.config.MapNode;
import com.agimatec.commons.config.sax.BigDecimalHandler;
import com.agimatec.commons.config.sax.BooleanHandler;
import com.agimatec.commons.config.sax.BooleanNodeHandler;
import com.agimatec.commons.config.sax.DecimalNodeHandler;
import com.agimatec.commons.config.sax.DoubleHandler;
import com.agimatec.commons.config.sax.DoubleNodeHandler;
import com.agimatec.commons.config.sax.FileNodeHandler;
import com.agimatec.commons.config.sax.IntNodeHandler;
import com.agimatec.commons.config.sax.IntegerHandler;
import com.agimatec.commons.config.sax.ListHandler;
import com.agimatec.commons.config.sax.ListNodeHandler;
import com.agimatec.commons.config.sax.LongHandler;
import com.agimatec.commons.config.sax.LongNodeHandler;
import com.agimatec.commons.config.sax.MapHandler;
import com.agimatec.commons.config.sax.MapNodeHandler;
import com.agimatec.commons.config.sax.NodeHandler;
import com.agimatec.commons.config.sax.StringHandler;
import com.agimatec.commons.config.sax.TextNodeHandler;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigContentHandler
extends DefaultHandler {
    private Config root;
    private Stack nodeStack;
    private Stack nodeHandlerStack;
    protected Map elementMap;
    protected ConfigManager myConfigManager;

    public ConfigContentHandler(ConfigManager aConfigManager) {
        this.myConfigManager = aConfigManager;
        this.elementMap = new HashMap();
        this.initElementMap();
    }

    public void characters(char[] chars, int offset, int length) throws SAXException {
        this.getCurrentHandler().acceptCharacters(this, chars, offset, length);
    }

    public void endDocument() throws SAXException {
        if (!this.nodeStack.empty()) {
            throw new SAXException("unexpected end of file");
        }
    }

    public void endElement(String uri, String elementName, String qName) throws SAXException {
        try {
            this.nodeStack.pop();
            this.nodeHandlerStack.pop();
        }
        catch (EmptyStackException ex) {
            throw new SAXException("internal error - no parent element for " + elementName);
        }
    }

    public void startDocument() throws SAXException {
        this.root = null;
        this.nodeStack = new Stack();
        this.nodeHandlerStack = new Stack();
    }

    protected final void initElementMap() {
        this.addHandler(new MapNodeHandler("config", Config.class));
        this.addHandler(new MapNodeHandler("map", MapNode.class));
        this.addHandler(new TextNodeHandler("text"));
        this.addHandler(new ListNodeHandler("list"));
        this.addHandler(new IntNodeHandler("int"));
        this.addHandler(new BooleanNodeHandler("boolean"));
        this.addHandler(new FileNodeHandler(this.myConfigManager, "file"));
        this.addHandler(new DecimalNodeHandler("decimal"));
        this.addHandler(new DoubleNodeHandler("double"));
        this.addHandler(new LongNodeHandler("long"));
        this.addHandler(new MapHandler("HashMap", HashMap.class));
        this.addHandler(new MapHandler("Hashtable", Hashtable.class));
        this.addHandler(new StringHandler("String"));
        this.addHandler(new IntegerHandler("Integer"));
        this.addHandler(new LongHandler("Long"));
        this.addHandler(new BooleanHandler("Boolean"));
        this.addHandler(new BigDecimalHandler("BigDecimal"));
        this.addHandler(new DoubleHandler("Double"));
        this.addHandler(new ListHandler("ArrayList", ArrayList.class));
        this.addHandler(new ListHandler("Vector", Vector.class));
    }

    public void addHandler(NodeHandler handler) {
        this.elementMap.put(handler.tag(), handler);
    }

    public NodeHandler removeHandler(String tag) {
        return (NodeHandler)this.elementMap.remove(tag);
    }

    public void startElement(String namespaceURI, String elementName, String qName, Attributes attr) throws SAXException {
        NodeHandler nodeHdlr = (NodeHandler)this.elementMap.get(elementName);
        if (nodeHdlr != null) {
            try {
                Object newNode = nodeHdlr.startNode(attr);
                this.acceptNode(nodeHdlr, newNode, attr);
            }
            catch (Exception ex) {
                throw new SAXException(ex);
            }
        } else {
            throw new SAXException("unknown element " + elementName);
        }
    }

    public Config getConfig() {
        return this.root;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void acceptNode(NodeHandler handler, Object aNode, Attributes attr) throws SAXException {
        if (this.root == null) {
            if (!(aNode instanceof Config)) throw new SAXException("<config> expected, but received " + handler.tag());
            this.root = (Config)aNode;
        } else {
            this.getCurrentHandler().acceptNode(this, aNode, attr);
        }
        this.nodeStack.push(aNode);
        this.nodeHandlerStack.push(handler);
    }

    protected NodeHandler getCurrentHandler() {
        return this.nodeHandlerStack.empty() ? null : (NodeHandler)this.nodeHandlerStack.peek();
    }

    protected Object getCurrentNode() {
        return this.nodeStack.peek();
    }
}

