/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.query;

import com.agimatec.sql.query.JdbcResultBuilder;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

public class ArrayResultBuilder
implements JdbcResultBuilder {
    protected int numCols;
    protected List result;
    protected int[] colTypes;
    protected Object[] row;

    public void afterExecute(ResultSetMetaData rsmData, Object queryObject, List resultList) throws SQLException {
        this.numCols = rsmData.getColumnCount();
        this.initColTypes(rsmData);
        this.result = resultList;
        this.row = null;
    }

    private void initColTypes(ResultSetMetaData rsmData) throws SQLException {
        this.colTypes = new int[this.numCols];
        for (int i = 0; i < this.colTypes.length; ++i) {
            int scale;
            this.colTypes[i] = rsmData.getColumnType(i + 1);
            if (this.colTypes[i] != 2 && this.colTypes[i] != 3 || (scale = rsmData.getScale(i + 1)) != 0) continue;
            this.colTypes[i] = 4;
        }
    }

    public void fetch(ResultSet resultSet) throws SQLException {
        if (this.row != null) {
            this.result.add(this.row);
        }
        this.row = new Object[this.numCols];
        block13: for (int i = 1; i <= this.numCols; ++i) {
            switch (this.colTypes[i - 1]) {
                case 2004: {
                    this.row[i - 1] = resultSet.getBytes(i);
                    continue block13;
                }
                case 4: 
                case 5: {
                    try {
                        this.row[i - 1] = resultSet.getInt(i);
                        continue block13;
                    }
                    catch (SQLException ex) {
                        try {
                            this.row[i - 1] = resultSet.getBigDecimal(i);
                            this.colTypes[i - 1] = -5;
                            continue block13;
                        }
                        catch (SQLException ex2) {
                            ex.setNextException(ex2);
                            throw ex;
                        }
                    }
                }
                case 2: {
                    this.row[i - 1] = resultSet.getDouble(i);
                    continue block13;
                }
                case 93: {
                    this.row[i - 1] = resultSet.getTimestamp(i);
                    continue block13;
                }
                case 2005: {
                    Clob clob = resultSet.getClob(i);
                    if (clob != null) {
                        this.row[i - 1] = clob.getSubString(1L, (int)clob.length());
                        continue block13;
                    }
                    this.row[i - 1] = null;
                    continue block13;
                }
                case -3: 
                case -2: {
                    this.row[i - 1] = resultSet.getBytes(i);
                    continue block13;
                }
                case -5: {
                    this.row[i - 1] = resultSet.getBigDecimal(i);
                    continue block13;
                }
                default: {
                    this.row[i - 1] = resultSet.getObject(i);
                }
            }
        }
    }

    public void close(boolean isComplete) {
        if (this.row != null) {
            this.result.add(this.row);
        }
    }
}

