/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbmigrate;

import com.agimatec.commons.config.Config;
import com.agimatec.commons.config.ConfigManager;
import com.agimatec.commons.config.FileNode;
import com.agimatec.commons.util.ResourceUtils;
import com.agimatec.dbmigrate.BaseMigrationTool;
import com.agimatec.dbmigrate.DBVersionString;
import com.agimatec.dbmigrate.action.ChangeDirCommand;
import com.agimatec.dbmigrate.action.MigrateAction;
import com.agimatec.dbmigrate.action.OperationAction;
import com.agimatec.dbmigrate.action.ScriptAction;
import com.agimatec.dbmigrate.util.SQLCursor;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoMigrationTool
extends BaseMigrationTool {
    private Map<Object, Object> localEnv = null;
    private boolean sim = false;
    private boolean exitJVM = true;
    private List<MigrateAction> actionOverride;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block8: {
            AutoMigrationTool tool = new AutoMigrationTool();
            try {
                if (!tool.parseArgs(args)) {
                    return;
                }
                try {
                    tool.setUp();
                    tool.startAutomaticMigration();
                }
                finally {
                    tool.tearDown();
                }
                if (tool.exitJVM) {
                    System.exit(0);
                }
            }
            catch (Throwable ex) {
                log.error(null, ex);
                if (!tool.exitJVM) break block8;
                System.exit(1);
            }
        }
    }

    public boolean isSim() {
        return this.sim;
    }

    private boolean parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String each = args[i];
            if ("-exit".equalsIgnoreCase(each)) {
                this.exitJVM = "true".equalsIgnoreCase(args[++i]) || "yes".equalsIgnoreCase(args[i]);
                continue;
            }
            if ("-sim".equalsIgnoreCase(each)) {
                this.sim = "true".equalsIgnoreCase(args[++i]) || "yes".equalsIgnoreCase(args[i]);
                continue;
            }
            if ("-conf".equalsIgnoreCase(each)) {
                this.setMigrateConfigFileName(args[++i]);
                continue;
            }
            if ("-base".equalsIgnoreCase(args[i])) {
                this.setConfigRootUrl(args[++i]);
                continue;
            }
            if ("-help".equalsIgnoreCase(each)) {
                this.printUsage();
                return false;
            }
            if ("-script".equalsIgnoreCase(each)) {
                ScriptAction action;
                if ((action = ScriptAction.create(this, args[++i])) == null) continue;
                this.addActionOverride(action);
                continue;
            }
            if (!"-op".equalsIgnoreCase(each)) continue;
            String op = args[++i];
            String param = "";
            if (++i < args.length) {
                param = args[i];
            }
            this.addActionOverride(new OperationAction(this, op, param));
        }
        return true;
    }

    private void addActionOverride(MigrateAction operationAction) {
        if (this.actionOverride == null) {
            this.actionOverride = new LinkedList<MigrateAction>();
        }
        this.actionOverride.add(operationAction);
    }

    private void printUsage() {
        System.out.println("usage: java " + this.getClass().getName() + " -sim false -exit true -root url -conf migration.xml -script aScript -op operationName " + "operationParameter ");
        System.out.println("Options:\n\t-help \t (optional) print this help");
        System.out.println("\t-sim \t (optional) true|yes=simulation only, default is false");
        System.out.println("\t-conf \t (optional) name of migration.xml configuration file, default is migration.xml");
        System.out.println("\t-script \t (optional, multiple occurrence supported) name of a upgrade-file (sql, groovy, xml) with operations. tool will execute the given file(s) only!");
        System.out.println("\t-op \t (optional, multiple occurrence supported) the operation in the same syntax as in an upgrade-file. tool will execute the given operation(s) only!");
        System.out.println("\t-exit \t (optional) true|yes to exit JVM after main(), otherwise no System.exit() will be invoked");
        System.out.println("\t-base \t (optional) set the config base URL of the resource or directory, defaults to the path given in resource 'configmanager.ini' or file: if none available");
    }

    @Override
    public Map getEnvironment() {
        if (this.localEnv == null) {
            return super.getEnvironment();
        }
        return this.localEnv;
    }

    protected Map<?, ?> getMigrateEnvironment() {
        return super.getEnvironment();
    }

    public void startAutomaticMigration() throws Exception {
        this.log("----------------- start migration -----------------");
        this.connectTargetDatabase();
        if (this.actionOverride != null && !this.actionOverride.isEmpty()) {
            this.print("performing command line actions only!");
            this.performActions(this.actionOverride);
        } else {
            this.performActions(this.createActions());
        }
    }

    public void performActions(List<MigrateAction> actionOverride) throws Exception {
        if (this.sim) {
            this.print("simulation only - sequence follows:");
        }
        try {
            if (actionOverride.isEmpty()) {
                this.print("There are no actions to perform.");
            } else {
                int i = 0;
                for (MigrateAction each : actionOverride) {
                    this.print("action " + ++i + " (of " + actionOverride.size() + ") = " + each.getInfo());
                    each.doIt();
                }
            }
        }
        catch (Exception ex) {
            this.rollback();
            this.log(ex);
            throw ex;
        }
    }

    protected void prepareLocalEnvironment(Config cfg) {
        Map tempEnv = cfg.getMap("env");
        if (tempEnv != null) {
            this.localEnv = new HashMap(this.getMigrateEnvironment());
            this.localEnv.putAll(tempEnv);
            this.replaceProperties(this.localEnv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doXmlScript(String filePath) throws Exception {
        if (!this.sim) {
            Config cfg = ConfigManager.getDefault().readConfig(filePath, false);
            try {
                this.prepareLocalEnvironment(cfg);
                this.perform(cfg.getList("Operations"));
            }
            finally {
                this.localEnv = null;
            }
        }
    }

    public DBVersionString getToVersion() {
        String ver = this.getMigrateConfig().getString("to-version");
        if (ver == null || ver.length() == 0) {
            return null;
        }
        this.print("Using to-version: " + ver);
        return DBVersionString.fromString(ver);
    }

    public DBVersionString getFromVersion() throws SQLException {
        DBVersionString version;
        String ver = this.getMigrateConfig().getString("from-version");
        if (ver == null || ver.length() == 0) {
            version = this.readVersion();
            this.print("Current database version: " + version);
        } else {
            version = DBVersionString.fromString(ver);
            this.print("Using from-version: " + version);
        }
        return version;
    }

    private List<DBVersionString> filterVersions(DBVersionString version, List<DBVersionString> versionFiles) {
        Iterator<DBVersionString> iter = versionFiles.iterator();
        DBVersionString toversion = this.getToVersion();
        while (iter.hasNext()) {
            DBVersionString each = iter.next();
            if (!each.isLater(version)) {
                iter.remove();
                continue;
            }
            if (toversion == null || !each.isLater(toversion)) continue;
            iter.remove();
        }
        return versionFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBVersionString readVersion() throws SQLException {
        String version;
        block6: {
            version = null;
            try {
                SQLCursor rs = this.sqlSelect(this.getDbVersionMeta().toSQLSelectVersion());
                if (rs == null) break block6;
                try {
                    while (rs.next()) {
                        version = rs.getString(1);
                    }
                }
                finally {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warn("cannot read " + this.getDbVersionMeta().getQualifiedVersionColumn() + " because " + ex.getMessage());
            }
        }
        return version == null ? null : DBVersionString.fromString(version);
    }

    private List<MigrateAction> createActions() throws SQLException, IOException {
        List<MigrateAction> actions;
        String upDir = this.getScriptsDir();
        List<DBVersionString> files = this.filterVersions(this.getFromVersion(), this.readDir(this.getScriptPrefix(), upDir));
        String beforeDir = this.getBeforeAllScriptsDir();
        if (beforeDir != null) {
            List<DBVersionString> before = this.readDir(null, beforeDir);
            actions = this.createActions(before, false);
            actions.add(0, new ChangeDirCommand(this, beforeDir));
            if (upDir != null || !files.isEmpty()) {
                actions.add(new ChangeDirCommand(this, upDir));
                actions.addAll(this.createActions(files, this.getDbVersionMeta().isAutoVersion()));
            }
        } else {
            actions = this.createActions(files, this.getDbVersionMeta().isAutoVersion());
        }
        this.addActionsAfterAll(this.getAfterAllScriptsDir(), actions);
        return actions;
    }

    public void addActionsAfterAll(String dir, List<MigrateAction> actions) throws IOException {
        if (dir != null) {
            actions.add(new ChangeDirCommand(this, dir));
            actions.addAll(this.createActions(this.readDir(null, dir), false));
        }
    }

    public List<MigrateAction> createUpgradeActions(String scriptDir, boolean enableAutoVersion) throws SQLException, IOException {
        List<DBVersionString> files = this.filterVersions(this.getFromVersion(), this.readDir(this.getScriptPrefix(), scriptDir));
        ArrayList<MigrateAction> actions = new ArrayList<MigrateAction>();
        if (scriptDir != null || !files.isEmpty()) {
            actions.add(new ChangeDirCommand(this, scriptDir));
            actions.addAll(this.createActions(files, enableAutoVersion && this.getDbVersionMeta().isAutoVersion()));
        }
        return actions;
    }

    public String getScriptPrefix() {
        String prefix = this.getMigrateConfig().getString("Scripts-Prefix");
        if (prefix == null) {
            return "up-";
        }
        return prefix;
    }

    private List<MigrateAction> createActions(List<DBVersionString> files, boolean autoVersion) {
        LinkedList<MigrateAction> actions = new LinkedList<MigrateAction>();
        for (DBVersionString file : files) {
            ScriptAction action = ScriptAction.create(this, file.getFileName(), file.getFileType());
            if (action == null) continue;
            actions.add(action);
            if (!autoVersion) continue;
            actions.add(new OperationAction(this, "version", file.getVersion()));
        }
        return actions;
    }

    private List<DBVersionString> readDir(String prefix, String directory) throws IOException {
        if (directory == null) {
            return new ArrayList<DBVersionString>();
        }
        Collection<String> resources = this.readResources(directory);
        ArrayList<DBVersionString> order = new ArrayList<DBVersionString>(resources.size());
        for (String each : resources) {
            DBVersionString ver = DBVersionString.fromString(prefix, each);
            if (ver == null) continue;
            order.add(ver);
        }
        Collections.sort(order);
        return order;
    }

    private Collection<String> readResources(String directory) throws IOException {
        HashSet<String> resources = new HashSet<String>();
        for (URL each : ConfigManager.toURLs(directory)) {
            log.debug("directory " + directory + " -> reading: " + each);
            resources.addAll(ResourceUtils.getURLResources(each));
        }
        return resources;
    }

    public String getBeforeAllScriptsDir() {
        FileNode dir = (FileNode)this.getMigrateConfig().get("Scripts-Before-All");
        return dir == null ? null : dir.getFilePath();
    }

    public String getAfterAllScriptsDir() {
        FileNode dir = (FileNode)this.getMigrateConfig().get("Scripts-After-All");
        return dir == null ? null : dir.getFilePath();
    }

    public Map<Object, Object> getLocalEnv() {
        return this.localEnv;
    }

    public List<MigrateAction> getActionOverride() {
        return this.actionOverride;
    }

    public void setActionOverride(List<MigrateAction> actionOverride) {
        this.actionOverride = actionOverride;
    }

    public void setSim(boolean sim) {
        this.sim = sim;
    }

    public void setLocalEnv(Map<Object, Object> localEnv) {
        this.localEnv = localEnv;
    }

    public void setExitJVM(boolean exitJVM) {
        this.exitJVM = exitJVM;
    }

    public boolean isExitJVM() {
        return this.exitJVM;
    }
}

