/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.query;

import com.agimatec.sql.SQLStatement;
import com.agimatec.sql.query.JdbcExecutor;
import com.agimatec.sql.query.JdbcResultBuilder;
import com.agimatec.sql.query.QueryDefinition;
import com.agimatec.sql.query.QueryResult;
import com.agimatec.sql.query.SQLBuilder;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JdbcQueryUtil
extends JdbcExecutor
implements Serializable {
    protected final Connection connection;
    protected final SQLBuilder sqlBuilder;
    protected static final Log log = LogFactory.getLog(JdbcQueryUtil.class);

    public JdbcQueryUtil(Connection aConnection, SQLBuilder aSqlBuilder) {
        this.connection = aConnection;
        this.sqlBuilder = aSqlBuilder;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public SQLBuilder getSqlBuilder() {
        return this.sqlBuilder;
    }

    public int executeUpdate(QueryDefinition updateDefinition) throws SQLException {
        SQLStatement sql = this.sqlBuilder.generateSQL(updateDefinition);
        return this.execRowsAffected(sql);
    }

    public int executeCount(QueryDefinition queryDefinition) throws Exception {
        QueryResult result = this.executeQuery(queryDefinition);
        if (result.getList().isEmpty()) {
            return -1;
        }
        Object row = result.getList().get(0);
        if (row instanceof Number) {
            return ((Number)row).intValue();
        }
        Object[] theArray = (Object[])row;
        if (theArray == null || theArray.length == 0) {
            return -1;
        }
        if (theArray[0] instanceof Number) {
            return ((Number)theArray[0]).intValue();
        }
        return -1;
    }

    public QueryResult executeQuery(QueryDefinition queryDefinition) throws SQLException {
        SQLStatement query = this.sqlBuilder.generateSQL(queryDefinition);
        JdbcResultBuilder resultBuilder = this.newResultVisitor(this.sqlBuilder.getResultBuilderName(queryDefinition.getQueryName()));
        return this.fetchResult(query, resultBuilder, queryDefinition);
    }
}

