/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta.script;

import com.agimatec.sql.meta.script.A_ExtractPart;
import com.agimatec.sql.meta.script.ExtractProperty;
import com.agimatec.sql.meta.script.ExtractSeparator;
import com.agimatec.sql.meta.script.ExtractWord;
import com.agimatec.sql.meta.script.PropertiesExtractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ExtractExpr
extends A_ExtractPart {
    private final String name;
    private final List parts;
    private ExtractSeparator repeatSep;
    private boolean optional;
    private Map parent;

    public ExtractExpr(String aName) {
        this.name = aName;
        this.parts = new ArrayList();
        this.repeatSep = null;
    }

    public ExtractExpr(String aName, String repeatSeparator) {
        this.name = aName;
        this.parts = new ArrayList();
        this.repeatSep = new ExtractSeparator(repeatSeparator);
    }

    public ExtractExpr addWord(String word) {
        this.add(new ExtractWord(word, false));
        return this;
    }

    public ExtractExpr addOptionalWord(String word) {
        this.add(new ExtractWord(word, true));
        return this;
    }

    public ExtractExpr addSeparator() {
        this.add(new ExtractSeparator());
        return this;
    }

    public ExtractExpr addSeparator(String seperator) {
        this.add(new ExtractSeparator(seperator));
        return this;
    }

    public ExtractExpr addExpr(ExtractExpr expr) {
        this.add(expr);
        return this;
    }

    public ExtractExpr addOptionalExpr(ExtractExpr expr) {
        expr.optional = true;
        return this.addExpr(expr);
    }

    public ExtractExpr addProperty(String prop) {
        return this.addProperty(null, prop);
    }

    public ExtractExpr addOptionalProperty(String prop) {
        return this.addOptionalProperty(null, prop);
    }

    public ExtractExpr addOptionalProperty(String word, String propName) {
        this.add(new ExtractProperty(propName, word, true));
        return this;
    }

    public ExtractExpr addProperty(String word, String propName) {
        this.add(new ExtractProperty(propName, word, false));
        return this;
    }

    public ExtractExpr addProperty(String word, String propName, boolean isOptional, String startDelim, String endDelim) {
        ExtractProperty prop = new ExtractProperty(propName, word, isOptional);
        prop.setStartDelimeter(startDelim);
        prop.setEndDelimeter(endDelim);
        this.add(prop);
        return this;
    }

    private void add(A_ExtractPart part) {
        this.parts.add(part);
    }

    public Iterator parts() {
        return this.parts.iterator();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.optional) {
            buf.append("[");
        }
        Iterator theParts = this.parts();
        buf.append("{");
        buf.append(this.name);
        buf.append(' ');
        while (theParts.hasNext()) {
            A_ExtractPart part = (A_ExtractPart)theParts.next();
            buf.append(part);
            if (!theParts.hasNext()) continue;
            buf.append(" ");
        }
        if (this.isRepeating()) {
            buf.append("...");
            buf.append(this.getRepeatSep().toString());
        }
        buf.append('}');
        if (this.optional) {
            buf.append("]");
        }
        return buf.toString();
    }

    public int fits(String aToken) {
        return 3;
    }

    public int process(String aToken, PropertiesExtractor extractor) {
        int result;
        int storeIdx = extractor.getTokens().getPosition();
        this.parent = extractor.current;
        if (this.isRepeating()) {
            this.installRepeats();
            this.nextRepeatMap(extractor);
            result = extractor.process(this);
        } else {
            HashMap map = new HashMap();
            this.parent.put(this.name, map);
            extractor.current = map;
            result = extractor.process(this);
        }
        extractor.current = this.parent;
        if ((result == 0 || result == -1) && this.optional) {
            this.parent.remove(this.name);
            extractor.setToken(aToken);
            extractor.getTokens().setPosition(storeIdx);
            return 3;
        }
        return result == -1 ? 0 : result;
    }

    private void installRepeats() {
        ArrayList repeats = new ArrayList();
        this.parent.put(this.name, repeats);
    }

    private Map nextRepeatMap(PropertiesExtractor extractor) {
        HashMap map;
        extractor.current = map = new HashMap();
        this.getRepeats().add(map);
        return map;
    }

    private List getRepeats() {
        return (List)this.parent.get(this.name);
    }

    boolean isRepeating() {
        return this.repeatSep != null;
    }

    public ExtractSeparator getRepeatSep() {
        return this.repeatSep;
    }

    void setRepeatSep(ExtractSeparator aRepeatSep) {
        this.repeatSep = aRepeatSep;
    }

    public int prepareLoop(String aToken, PropertiesExtractor extractor) {
        int result = this.getRepeatSep().fits(aToken);
        if (result == 1 || result == 2) {
            this.nextRepeatMap(extractor);
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    protected boolean isOptional() {
        return this.optional;
    }
}

