/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta.script;

import com.agimatec.sql.meta.ColumnDescription;
import com.agimatec.sql.meta.oracle.OracleDDLExpressions;
import com.agimatec.sql.meta.postgres.PostgresDDLExpressions;
import com.agimatec.sql.meta.script.ExtractExpr;

public abstract class DDLExpressions {
    public abstract ExtractExpr[] getExpressions();

    public static DDLExpressions forDbms(String dbms) {
        if ("oracle".equalsIgnoreCase(dbms)) {
            return new OracleDDLExpressions();
        }
        if ("postgres".equalsIgnoreCase(dbms)) {
            return new PostgresDDLExpressions();
        }
        return null;
    }

    protected DDLExpressions() {
    }

    public ExtractExpr getExpression(String expName) {
        for (ExtractExpr each : this.getExpressions()) {
            if (!expName.equals(each.getName())) continue;
            return each;
        }
        return null;
    }

    public abstract void equalizeColumn(ColumnDescription var1);

    public String toString() {
        return this.getClass().getName();
    }
}

