/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta;

import com.agimatec.sql.meta.A_IntegrityRuleDescription;
import com.agimatec.sql.meta.ForeignKeyDescription;
import com.agimatec.sql.meta.SequenceDescription;
import com.agimatec.sql.meta.TableDescription;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="catalog")
public class CatalogDescription
implements Serializable,
Cloneable {
    private Map<String, TableDescription> tables = new HashMap<String, TableDescription>();
    private Map<String, SequenceDescription> sequences = new HashMap<String, SequenceDescription>();
    private String schemaName;

    public CatalogDescription deepCopy() {
        try {
            CatalogDescription clone = (CatalogDescription)this.clone();
            clone.tables = new HashMap<String, TableDescription>(this.tables.size());
            for (TableDescription tableDescription : this.tables.values()) {
                clone.addTable(tableDescription.deepCopy());
            }
            clone.sequences = new HashMap<String, SequenceDescription>(this.sequences.size());
            for (SequenceDescription sequenceDescription : this.sequences.values()) {
                clone.addSequence(sequenceDescription.deepCopy());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public TableDescription getTable(String tableName) {
        return this.tables.get(tableName.toUpperCase());
    }

    public SequenceDescription getSequence(String seqName) {
        return this.sequences.get(seqName);
    }

    public void addTable(TableDescription aTD) {
        this.tables.put(aTD.getTableName().toUpperCase(), aTD);
    }

    public void addSequence(SequenceDescription aSD) {
        this.sequences.put(aSD.getSequenceName(), aSD);
    }

    public int getTablesSize() {
        return this.tables.size();
    }

    public int getSequencesSize() {
        return this.sequences.size();
    }

    public Map<String, TableDescription> getTables() {
        return this.tables;
    }

    public Collection<SequenceDescription> getSequences() {
        return this.sequences.values();
    }

    public Collection<TableDescription> getTableCollection() {
        return this.tables.values();
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String aSchemaName) {
        this.schemaName = aSchemaName;
    }

    public String[] getTableNames() {
        Object[] theTables = new String[this.getTables().size()];
        int pos = 0;
        for (TableDescription tableDescription : this.getTables().values()) {
            theTables[pos++] = tableDescription.getTableName();
        }
        Arrays.sort(theTables);
        return theTables;
    }

    public void removeTable(String tableName) {
        this.tables.remove(tableName.toUpperCase());
    }

    public ForeignKeyDescription[] getForeignKeysReferencing(String tableName) {
        ArrayList<ForeignKeyDescription> referrers = new ArrayList<ForeignKeyDescription>();
        for (TableDescription tableDescription : this.getTables().values()) {
            for (int fkIdx = 0; fkIdx < tableDescription.getForeignKeySize(); ++fkIdx) {
                ForeignKeyDescription fk = tableDescription.getForeignKey(fkIdx);
                if (!tableName.equalsIgnoreCase(fk.getRefTableName())) continue;
                referrers.add(fk);
            }
        }
        return referrers.toArray(new ForeignKeyDescription[referrers.size()]);
    }

    public static List getTableNames(A_IntegrityRuleDescription[] rules) {
        HashSet<String> tableNames = new HashSet<String>(rules.length);
        for (A_IntegrityRuleDescription theRule : rules) {
            tableNames.add(theRule.getTableName());
        }
        ArrayList list = new ArrayList(tableNames);
        Collections.sort(list);
        return list;
    }
}

