/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbtransform;

import com.agimatec.commons.generator.GeneratorSettings;
import com.agimatec.commons.generator.GeneratorTool;
import com.agimatec.dbtransform.CatalogConversion;
import com.agimatec.dbtransform.CatalogGeneratorSettings;
import com.agimatec.dbtransform.ejb3.Ejb3Schema;
import com.agimatec.sql.meta.CatalogDescription;
import com.agimatec.sql.meta.persistence.XStreamPersistencer;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CatalogGeneratorTool
extends GeneratorTool {
    protected static final Log log = LogFactory.getLog(CatalogGeneratorTool.class);
    private CatalogConversion config;

    protected CatalogConversion getConfig() {
        return this.config;
    }

    protected void readConfig(File configFile) throws IOException, ClassNotFoundException {
        if (configFile != null) {
            this.config = (CatalogConversion)new XStreamPersistencer().load(configFile);
        }
    }

    protected String getDestFile(String templateBaseName) {
        return this.getSettings().getOutputPrefix() + templateBaseName + "-" + this.dbms + this.getSettings().getOutputSuffix();
    }

    private CatalogGeneratorSettings getSettings() {
        return (CatalogGeneratorSettings)this.settings;
    }

    protected File getCatalogFile(String destDir, String templateBaseName) {
        return new File(destDir + "/" + templateBaseName + "-" + this.dbms + ".xml");
    }

    public static void main(String[] args) throws Exception {
        CatalogGeneratorTool tool = new CatalogGeneratorTool();
        tool.runMain(args, new CatalogGeneratorSettings());
    }

    public void initialize(GeneratorSettings gsettings) throws IOException {
        CatalogGeneratorSettings settings = (CatalogGeneratorSettings)gsettings;
        super.initialize(settings);
        CatalogDescription catalog = settings.getCatalog();
        if (this.config != null) {
            log.info((Object)("Performing transformation: " + this.config.getName()));
            catalog = this.config.transformCatalog(catalog);
            this.templateEngine.putModel("catalog", catalog);
            this.templateEngine.putModel("ejb3schema", new Ejb3Schema(catalog));
            if (settings.getCatalogFile() != null) {
                log.info((Object)("Saving transformed catalog to " + settings.getCatalogFile()));
                File f = new File(settings.getCatalogFile()).getParentFile();
                if (f != null) {
                    f.mkdirs();
                }
                new XStreamPersistencer().save(catalog, new File(settings.getCatalogFile()));
            }
        } else {
            this.templateEngine.putModel("catalog", catalog);
            this.templateEngine.putModel("ejb3schema", new Ejb3Schema(catalog));
            log.info((Object)"Skipped transformation, it has been disabled!");
        }
    }
}

