/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbmigrate.util;

import com.agimatec.dbmigrate.util.DBVersionMeta;
import com.agimatec.dbmigrate.util.ScriptVisitorDelegate;
import com.agimatec.jdbc.JdbcDatabase;
import com.agimatec.sql.script.ScriptVisitor;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateVersionScriptVisitor
extends ScriptVisitorDelegate {
    private static final Log log = LogFactory.getLog(UpdateVersionScriptVisitor.class);
    private final JdbcDatabase jdbcStore;
    private final DBVersionMeta meta;

    public UpdateVersionScriptVisitor(JdbcDatabase aStore, ScriptVisitor aVisitor, DBVersionMeta meta) {
        super(aVisitor);
        this.jdbcStore = aStore;
        this.meta = meta == null ? new DBVersionMeta() : meta;
    }

    public void visitComment(String theComment) throws SQLException {
        super.visitComment(theComment);
        int idx = theComment.indexOf("@version");
        if (idx < 0) {
            idx = theComment.indexOf("#version");
        }
        if (idx >= 0) {
            StringTokenizer tokens = new StringTokenizer(theComment.substring(idx + "#version".length()), "()");
            String dbVersion = null;
            if (tokens.hasMoreTokens()) {
                dbVersion = tokens.nextToken();
            }
            if (dbVersion == null) {
                log.warn((Object)("cannot find a version in " + theComment));
            } else {
                UpdateVersionScriptVisitor.updateVersionInDatabase(this.jdbcStore, dbVersion, this.meta);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateVersionInDatabase(JdbcDatabase jdbcStore, String dbVersion, DBVersionMeta meta) throws SQLException {
        PreparedStatement s;
        log.info((Object)("*** update version to: " + dbVersion));
        int count = 0;
        boolean canAccessDbVersionTable = true;
        if (!meta.isInsertOnly()) {
            s = jdbcStore.getConnection().prepareStatement(meta.toSQLUpdate());
            try {
                UpdateVersionScriptVisitor.setParameters(s, dbVersion, meta);
                count = s.executeUpdate();
            }
            catch (SQLException ex) {
                log.warn((Object)("cannot update " + meta.getQualifiedVersionColumn() + " = " + dbVersion + " because " + ex.getMessage()));
                canAccessDbVersionTable = UpdateVersionScriptVisitor.createTable(jdbcStore, meta);
                if (!canAccessDbVersionTable) {
                    log.info((Object)("autoCreate=false, create table " + meta.getTableName() + " to persist the database version: " + dbVersion));
                }
            }
            finally {
                s.close();
            }
        }
        if (count == 0 && canAccessDbVersionTable) {
            s = jdbcStore.getConnection().prepareStatement(meta.toSQLInsert());
            try {
                UpdateVersionScriptVisitor.setParameters(s, dbVersion, meta);
                s.execute();
            }
            finally {
                s.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createTable(JdbcDatabase jdbcStore, DBVersionMeta meta) throws SQLException {
        if (!meta.isAutoCreate()) {
            return false;
        }
        Statement stmt = jdbcStore.getConnection().createStatement();
        try {
            stmt.execute(meta.toSQLCreateTable());
            log.info((Object)("autoCreate=true, created table " + meta.getTableName()));
        }
        finally {
            stmt.close();
        }
        return true;
    }

    private static void setParameters(PreparedStatement s, String dbVersion, DBVersionMeta meta) throws SQLException {
        s.setString(1, dbVersion);
        if (StringUtils.isNotEmpty((String)meta.getColumn_since())) {
            s.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
        }
    }
}

