/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbmigrate.util;

import com.agimatec.dbmigrate.util.ScriptVisitorDelegate;
import com.agimatec.sql.script.SQLScriptParser;
import com.agimatec.sql.script.ScriptVisitor;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SubscriptCapableVisitor
extends ScriptVisitorDelegate {
    private static final Log log = LogFactory.getLog(SubscriptCapableVisitor.class);
    private final SQLScriptParser parser;

    public SubscriptCapableVisitor(ScriptVisitor nextVisitor, SQLScriptParser parser) {
        super(nextVisitor);
        this.parser = parser;
    }

    public int visitStatement(String statement) throws SQLException {
        if (statement.startsWith("@")) {
            try {
                if (statement.charAt(1) == '>') {
                    this.parser.execSQLScript(this, statement.substring(2));
                } else {
                    this.parser.iterateSQLScript((ScriptVisitor)this, statement.substring(1));
                }
            }
            catch (Exception e) {
                log.error((Object)("error executing subscript: " + statement.substring(1)), (Throwable)e);
                throw new SQLException(e.getMessage(), e);
            }
            return 0;
        }
        if (statement.length() > 5 && statement.substring(0, 4).toLowerCase().equals("set ")) {
            this.doSetExpression(statement.substring(4));
            return 0;
        }
        return super.visitStatement(statement);
    }

    private void doSetExpression(String expression) {
        StringTokenizer tokens = new StringTokenizer(expression, "=,; ", true);
        String varName = this.nextToken(tokens, expression);
        while (tokens.hasMoreTokens()) {
            String nt = this.nextToken(tokens, expression);
            if (!"=".equals(nt) && !" ".equals(nt)) {
                log.warn((Object)("Illegal operator, expected '=' in: " + expression));
                return;
            }
            if (!"=".equals(nt)) continue;
            break;
        }
        String value = this.nextToken(tokens, expression);
        if (varName == null || value == null) {
            return;
        }
        if (varName.equals("FAIL_ON_ERROR")) {
            boolean bool = Boolean.parseBoolean(value);
            log.info((Object)("SET " + varName + "=" + bool + ";"));
            this.parser.setFailOnError(bool);
        } else {
            log.warn((Object)("Illegal script set-option: " + expression));
        }
    }

    private String nextToken(StringTokenizer tokens, String expression) {
        if (!tokens.hasMoreTokens()) {
            log.warn((Object)("Illegal script set-option: " + expression));
            return null;
        }
        return tokens.nextToken();
    }
}

