/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbmigrate.groovy;

import com.agimatec.commons.config.ConfigManager;
import com.agimatec.commons.util.ClassUtils;
import com.agimatec.dbmigrate.MigrationTool;
import com.agimatec.dbmigrate.MigrationToolAware;
import groovy.lang.Binding;
import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.IOException;
import java.net.URL;

public class GroovyScriptTool
implements MigrationToolAware {
    private GroovyScriptEngine scriptEngine;
    private Binding binding = new Binding();

    public GroovyScriptTool(String rootDir) throws IOException {
        this.scriptEngine = rootDir == null ? new GroovyScriptEngine(new URL[]{ConfigManager.toURL("cp://")}, ClassUtils.getClassLoader()) : new GroovyScriptEngine(new URL[]{ConfigManager.toURL(rootDir)}, ClassUtils.getClassLoader());
    }

    public GroovyScriptTool(String[] rootDirs) throws IOException {
        if (rootDirs != null) {
            URL[] urls = new URL[rootDirs.length];
            int i = 0;
            for (String each : rootDirs) {
                urls[i] = ConfigManager.toURL(each);
                ++i;
            }
            this.scriptEngine = new GroovyScriptEngine(urls, ClassUtils.getClassLoader());
        } else {
            this.scriptEngine = new GroovyScriptEngine(new URL[]{ConfigManager.toURL("cp://")}, ClassUtils.getClassLoader());
        }
    }

    public void start(String groovyScript) throws ScriptException, ResourceException {
        this.scriptEngine.run(groovyScript, this.binding);
    }

    public void setMigrationTool(MigrationTool tool) {
        this.binding.setVariable("tool", (Object)tool);
    }

    public Binding getBinding() {
        return this.binding;
    }

    public GroovyScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }
}

