/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.commons.util;

import com.agimatec.commons.util.ClassUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtils {
    public static List<String> readLines(String path) throws IOException {
        ClassLoader cl = ClassUtils.class.getClassLoader();
        ArrayList<String> lines = new ArrayList<String>();
        Enumeration<URL> e = cl.getResources(path);
        while (e.hasMoreElements()) {
            URL each = e.nextElement();
            lines.addAll(ResourceUtils.readLines(each));
        }
        return lines;
    }

    public static List<String> readLines(URL url) throws IOException {
        return ResourceUtils.readLines(ResourceUtils.newReader(url));
    }

    public static List<String> readLines(BufferedReader reader) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        ResourceUtils.eachLine(reader, lines);
        return lines;
    }

    private static BufferedReader newReader(URL url) throws IOException {
        return ResourceUtils.newReader(url.openConnection().getInputStream());
    }

    private static BufferedReader newReader(InputStream stream) {
        return new BufferedReader(new InputStreamReader(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void eachLine(BufferedReader br, List<String> lines) throws IOException {
        try {
            String line;
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
        }
        finally {
            br.close();
        }
    }
}

