/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.commons.generator;

import freemarker.core.Environment;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FreemarkerFileGenerator {
    protected static final Log log = LogFactory.getLog(FreemarkerFileGenerator.class);
    protected Configuration freemarker;
    private Map root = new HashMap();
    private String templateName;
    private String charset = null;
    public static final String UTF8 = "UTF-8";
    private String destFileName;
    private String baseDir;
    private boolean defaultDestFile = true;
    private boolean defaultTemplateName = true;
    public static final Writer NullWriter = new Writer(){

        public void write(char[] cbuf, int off, int len) {
        }

        public void flush() {
        }

        public void close() {
        }
    };

    public FreemarkerFileGenerator(File templateDir) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Setting templateDir = " + templateDir));
        }
        this.freemarker = new Configuration();
        this.freemarker.setNumberFormat("0.######");
        if (templateDir != null) {
            this.freemarker.setDirectoryForTemplateLoading(templateDir);
        }
        this.putModel("generator", this);
        this.root.put("statics", BeansWrapper.getDefaultInstance().getStaticModels());
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
        this.defaultTemplateName = false;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setDestFileName(String target) {
        this.destFileName = target;
        this.defaultDestFile = false;
    }

    public void putModel(String name, Object obj) {
        this.root.put(name, obj);
    }

    public Map getRoot() {
        return this.root;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getDestFileName() {
        return this.destFileName;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws IOException, TemplateException {
        this.applyDefaults();
        Writer out = this.destFileName != null ? this.createWriter(this.getDestFile()) : NullWriter;
        if (log.isInfoEnabled()) {
            log.info((Object)("Generating " + this.templateName + " --> " + this.destFileName));
        }
        try {
            this.generate(out);
        }
        finally {
            out.close();
        }
    }

    public void generate(Writer out) throws IOException, TemplateException {
        this.applyDefaults();
        Template template = this.freemarker.getTemplate(this.templateName);
        template.process((Object)this.root, out);
    }

    public File getDestFile() {
        if (this.destFileName == null) {
            return null;
        }
        if (this.baseDir != null) {
            return new File(this.baseDir, this.destFileName);
        }
        return new File(this.destFileName);
    }

    private Writer createWriter(File file) throws FileNotFoundException {
        OutputStreamWriter out;
        File dir = file.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        if (this.charset != null) {
            Charset cs = Charset.forName(this.charset);
            this.freemarker.setDefaultEncoding(this.charset);
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), cs);
        } else {
            out = new OutputStreamWriter(new FileOutputStream(file));
        }
        return out;
    }

    public void outputToFile(String newDestFile) throws IOException {
        Environment env = Environment.getCurrentEnvironment();
        Writer former = env.getOut();
        former.flush();
        this.destFileName = newDestFile;
        Writer current = this.createWriter(this.getDestFile());
        env.setOut(current);
    }

    public void outputToNull() throws IOException {
        Writer former = Environment.getCurrentEnvironment().getOut();
        former.flush();
        Environment.getCurrentEnvironment().setOut(NullWriter);
    }

    public void outputToWriter(Writer outWriter) throws IOException {
        Environment env = Environment.getCurrentEnvironment();
        Writer former = env.getOut();
        former.flush();
        env.setOut(outWriter);
    }

    private void applyDefaults() {
        if (this.defaultTemplateName) {
            this.templateName = "template.ftl";
        }
        if (this.defaultDestFile) {
            this.destFileName = this.templateName + ".out";
        }
    }

    public Configuration getFreemarker() {
        return this.freemarker;
    }

    public List exeptLast(Collection coll) {
        LinkedList l = new LinkedList(coll);
        l.removeLast();
        return l;
    }

    public Object last(Collection coll) {
        LinkedList l = new LinkedList(coll);
        return l.removeLast();
    }

    public List exeptFirst(Collection coll) {
        LinkedList l = new LinkedList(coll);
        l.removeFirst();
        return l;
    }

    public Object first(Collection coll) {
        LinkedList l = new LinkedList(coll);
        return l.removeFirst();
    }
}

