/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.commons.config.sax;

import com.agimatec.commons.config.sax.ConfigContentHandler;
import com.agimatec.commons.config.sax.NodeHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.SAXException;

public class ConfigWriter
extends ConfigContentHandler {
    private Map typeHandlerMap;

    public ConfigWriter() {
        super(null);
        this.initReverseMap();
    }

    protected void initReverseMap() {
        Iterator iter = this.elementMap.values().iterator();
        this.typeHandlerMap = new HashMap();
        while (iter.hasNext()) {
            NodeHandler each = (NodeHandler)iter.next();
            this.typeHandlerMap.put(each.getInstanceClass(), each);
        }
    }

    public void writeConfig(Object config, PrintWriter pw) throws IOException, SAXException {
        this.writeNode(config, pw, 0, null);
    }

    protected void writeNode(Object node, PrintWriter pw, int indent, Object parentNode) throws SAXException {
        NodeHandler handler = node == null ? (NodeHandler)this.typeHandlerMap.get(String.class) : (NodeHandler)this.typeHandlerMap.get(node.getClass());
        if (handler == null) {
            throw new SAXException("unknown type " + node);
        }
        handler.writeConfig(this, node, parentNode, pw, indent);
    }
}

