/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.database;

import com.agimatec.database.AbstractDbTool;
import com.agimatec.sql.query.JdbcQueryUtil;
import com.agimatec.sql.query.QueryDefinition;
import com.agimatec.sql.query.QueryResult;
import com.agimatec.sql.query.SQLBuilder;
import com.agimatec.utility.fileimport.SqlUtil;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteHistoryTriggers
extends AbstractDbTool {
    protected static final Logger log = LoggerFactory.getLogger((String)"agimatec.migration");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        DeleteHistoryTriggers tool = new DeleteHistoryTriggers();
        try {
            tool.connectJdbc(args);
            try {
                tool.execute();
            }
            finally {
                tool.disconnect();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException, SQLException {
        SQLBuilder sqlBuilder = SqlUtil.forConnection((Connection)this.jdbcConnection).isOracle() ? new SQLBuilder("com/agimatec/sql/meta/oracle-statements.properties") : new SQLBuilder("com/agimatec/sql/meta/postgres-statements.properties");
        JdbcQueryUtil queryUtil = new JdbcQueryUtil(this.jdbcConnection, sqlBuilder);
        QueryDefinition def = new QueryDefinition();
        def.setQueryName("history-triggers");
        QueryResult triggers = queryUtil.executeQuery(def);
        Statement stmt = this.jdbcConnection.createStatement();
        try {
            for (String each : triggers) {
                String sql = queryUtil.getSqlBuilder().getSQL("drop-trigger");
                sql = MessageFormat.format(sql, each, each.substring(5));
                log.info(sql);
                stmt.execute(sql);
            }
            def.setQueryName("history-trigger-functions");
            QueryResult functions = queryUtil.executeQuery(def);
            for (String each : functions) {
                String sql = queryUtil.getSqlBuilder().getSQL("drop-function");
                sql = MessageFormat.format(sql, each);
                log.info(sql);
                stmt.execute(sql);
            }
        }
        finally {
            stmt.close();
        }
    }
}

