/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.utility.fileimport.spreadsheet;

import com.agimatec.utility.fileimport.LineReader;
import com.agimatec.utility.fileimport.spreadsheet.ExcelRow;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Row;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelRowReader
implements LineReader<ExcelRow> {
    private int sheetIndex = 0;
    private POIFSFileSystem fileSystem;
    private HSSFWorkbook workbook;
    private HSSFSheet sheet;
    private Iterator<Row> rowIterator;
    private InputStream stream;

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public void setSheetIndex(int sheetIndex) {
        this.sheetIndex = sheetIndex;
    }

    @Override
    public void setReader(Reader aReader) throws IOException {
        throw new UnsupportedOperationException("InputStream required");
    }

    @Override
    public void setStream(InputStream aReader) throws IOException {
        this.stream = aReader;
    }

    @Override
    public ExcelRow readLine() throws IOException {
        this.init();
        if (this.rowIterator.hasNext()) {
            return new ExcelRow(this.rowIterator.next());
        }
        return null;
    }

    protected void init() throws IOException {
        if (this.rowIterator != null) {
            return;
        }
        if (this.fileSystem == null) {
            this.fileSystem = new POIFSFileSystem(this.stream);
        }
        if (this.workbook == null) {
            this.workbook = new HSSFWorkbook(this.fileSystem);
        }
        if (this.sheet == null) {
            this.sheet = this.workbook.getSheetAt(this.sheetIndex);
        }
        this.rowIterator = this.sheet.rowIterator();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    public POIFSFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public void setFileSystem(POIFSFileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public Iterator<Row> getRowIterator() {
        return this.rowIterator;
    }

    public void setRowIterator(Iterator<Row> rowIterator) {
        this.rowIterator = rowIterator;
    }

    public HSSFSheet getSheet() {
        return this.sheet;
    }

    public void setSheet(HSSFSheet sheet) {
        this.sheet = sheet;
    }

    public HSSFWorkbook getWorkbook() {
        return this.workbook;
    }

    public void setWorkbook(HSSFWorkbook workbook) {
        this.workbook = workbook;
    }
}

