/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.utility.fileimport;

import com.agimatec.utility.fileimport.Importer;
import com.agimatec.utility.fileimport.ImporterException;
import com.agimatec.utility.fileimport.ImporterProcessor;
import com.agimatec.utility.fileimport.ImporterSpec;
import com.agimatec.utility.fileimport.LineImportProcessor;
import com.agimatec.utility.fileimport.LineReader;
import com.agimatec.utility.fileimport.LineTokenizerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.log4j.Logger;

public class LineImporterSpec
implements ImporterSpec {
    protected static final Logger log = Logger.getLogger(LineImporterSpec.class);
    private Header headerSpec = Header.NONE;
    private LineTokenizerFactory lineTokenizerFactory;
    private String[] fieldNames;
    private Writer errorWriter;
    private int headerLineIndex = 1;

    public LineTokenizerFactory getLineTokenizerFactory() {
        return this.lineTokenizerFactory;
    }

    public void setLineTokenizerFactory(LineTokenizerFactory lineTokenizerFactory) {
        this.lineTokenizerFactory = lineTokenizerFactory;
    }

    public Header getHeaderSpec() {
        return this.headerSpec;
    }

    public void setHeaderSpec(Header headerSpec) {
        this.headerSpec = headerSpec;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public void setFieldNames(String[] fieldNames) {
        this.fieldNames = fieldNames;
    }

    public void setErrorWriter(Writer errorWriter) {
        this.errorWriter = errorWriter;
    }

    public Writer getErrorWriter() {
        return this.errorWriter;
    }

    public ImporterProcessor createProcessor(Importer importer) {
        return new LineImportProcessor(this, importer);
    }

    public String getFieldName(int fieldIdx) {
        return this.fieldNames == null || this.fieldNames.length <= fieldIdx ? "field_" + fieldIdx : this.fieldNames[fieldIdx];
    }

    public void processRow(LineImportProcessor processor) throws ImporterException {
        log.info((Object)("row: " + processor.getRowCount() + " = " + processor.getCurrentRow()));
    }

    public void processHeaderLine(LineImportProcessor processor) throws ImporterException {
        log.info((Object)("header: " + processor.getRowCount() + " = " + processor.getHeaderLine()));
    }

    public void setHeaderLineIndex(int index) {
        this.headerLineIndex = index;
    }

    public int getHeaderLineIndex() {
        return this.headerLineIndex;
    }

    public LineReader createLineReader(Closeable aReader) throws IOException {
        LineReader lineReader = this.getLineTokenizerFactory().createLineReader();
        if (aReader instanceof Reader) {
            lineReader.setReader((Reader)aReader);
        } else if (aReader instanceof InputStream) {
            lineReader.setStream((InputStream)aReader);
        }
        return lineReader;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Header {
        NONE,
        FIRST,
        INDEX;

    }
}

