/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.utility.fileimport;

import com.agimatec.utility.fileimport.ImporterException;
import com.agimatec.utility.fileimport.ImporterProcessor;
import com.agimatec.utility.fileimport.ImporterSpec;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.log4j.Logger;

public class Importer {
    protected static final Logger log = Logger.getLogger(Importer.class);
    protected final ImporterProcessor processor;
    protected final ImporterSpec spec;

    public Importer(ImporterSpec spec) {
        this.spec = spec;
        this.processor = spec.createProcessor(this);
    }

    protected ImporterSpec getSpec() {
        return this.spec;
    }

    public final void setErrorWriter(Writer aErrorWriter) {
        this.processor.setErrorWriter(aErrorWriter);
    }

    public void importFrom(Reader aReader) throws ImporterException {
        this.processor.importFrom(aReader);
    }

    public void importFrom(InputStream aStream) throws ImporterException {
        this.processor.importFrom(aStream);
    }

    public int getRowCount() {
        return this.processor.getRowCount();
    }

    public int getErrorCount() {
        return this.processor.getErrorCount();
    }

    public boolean isCancelled() {
        return this.processor.isCancelled();
    }

    public Throwable getLastException() {
        Object err = this.processor.getLastError();
        return err instanceof Throwable ? (Throwable)err : null;
    }

    public String getLastErrorMessage() {
        Object err = this.processor.getLastError();
        if (err instanceof Throwable) {
            return ((Throwable)err).getLocalizedMessage();
        }
        if (err != null) {
            return String.valueOf(err);
        }
        return null;
    }

    public void log(Object obj) {
        if (obj instanceof Throwable) {
            log.error(null, (Throwable)obj);
        } else {
            log.info(obj);
        }
    }
}

