/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.utility.fileimport;

import com.agimatec.utility.fileimport.LineTokenizer;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CSVStringTokenizer
implements LineTokenizer<String, String> {
    private final String mySeparators;
    private final String myQuotaChar;
    private StringTokenizer myTokenizer;
    private boolean wasSeparator;
    private boolean lineIncomplete;

    public CSVStringTokenizer(String object, String separators) {
        this(object, separators, "\"");
    }

    public CSVStringTokenizer(String object, String separators, String extraDelimeter) {
        this.mySeparators = separators;
        this.myQuotaChar = extraDelimeter;
        this.initTokenizer(object);
    }

    private void initTokenizer(String object) {
        this.wasSeparator = false;
        this.lineIncomplete = false;
        this.myTokenizer = new StringTokenizer(object, this.myQuotaChar != null ? this.mySeparators + this.myQuotaChar : this.mySeparators, true);
    }

    @Override
    public boolean isLineIncomplete() {
        return this.lineIncomplete;
    }

    @Override
    public String continueParse(String aSingleValue, String aRecord) {
        this.initTokenizer(aRecord);
        return aSingleValue + "\n" + this.parseQuoted();
    }

    @Override
    public boolean hasMoreElements() {
        return this.myTokenizer.hasMoreTokens() || this.wasSeparator;
    }

    @Override
    public String nextElement() {
        String result;
        if (this.myTokenizer.hasMoreTokens()) {
            result = this.parseToken();
        } else if (this.wasSeparator) {
            this.wasSeparator = false;
            result = "";
        } else {
            throw new NoSuchElementException();
        }
        return result;
    }

    private boolean isSeparator(String each) {
        return this.mySeparators.indexOf(each) >= 0;
    }

    private boolean isQuota(String each) {
        return this.myQuotaChar != null && this.myQuotaChar.equals(each);
    }

    private String parseToken() {
        String each = this.myTokenizer.nextToken();
        if (this.isSeparator(each)) {
            return "";
        }
        if (this.isQuota(each)) {
            this.wasSeparator = false;
            return this.parseQuoted();
        }
        this.wasSeparator = false;
        return this.parseNormal(each);
    }

    private String parseNormal(String each) {
        StringBuilder buf = new StringBuilder(each);
        while (this.myTokenizer.hasMoreTokens()) {
            each = this.myTokenizer.nextToken();
            if (this.isSeparator(each)) {
                this.wasSeparator = true;
                break;
            }
            buf.append(each);
        }
        return buf.toString();
    }

    private String parseQuoted() {
        StringBuilder buf = new StringBuilder();
        boolean maybeDoubleQuota = false;
        while (this.myTokenizer.hasMoreTokens()) {
            String each = this.myTokenizer.nextToken();
            if (this.isQuota(each)) {
                if (maybeDoubleQuota) {
                    buf.append(this.myQuotaChar);
                    maybeDoubleQuota = false;
                    continue;
                }
                maybeDoubleQuota = true;
                continue;
            }
            if (maybeDoubleQuota) {
                if (!this.isSeparator(each)) {
                    throw new IllegalArgumentException("separator expected, but found: " + each);
                }
                this.wasSeparator = true;
                break;
            }
            buf.append(each);
        }
        if (!maybeDoubleQuota) {
            this.lineIncomplete = true;
        }
        return buf.toString();
    }
}

