/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.utility.fileimport.spreadsheet;

import com.agimatec.utility.fileimport.ImporterException;
import com.agimatec.utility.fileimport.LineImportProcessor;
import com.agimatec.utility.fileimport.LineReader;
import com.agimatec.utility.fileimport.spreadsheet.ExcelFormat;
import com.agimatec.utility.fileimport.spreadsheet.ExcelRow;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelRowReader
implements LineReader<ExcelRow> {
    protected ExcelFormat format = ExcelFormat.HSSF;
    private int sheetIndex = 0;
    private Workbook workbook;
    private Sheet sheet;
    private Iterator<Row> rowIterator;
    private InputStream stream;
    private String sheetName;
    private final boolean keepOpen;

    public ExcelRowReader(boolean keepOpen) {
        this.keepOpen = keepOpen;
    }

    public ExcelRowReader() {
        this.keepOpen = false;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
        this.setSheet(null);
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public boolean isKeepOpen() {
        return this.keepOpen;
    }

    public ExcelFormat getFormat() {
        return this.format;
    }

    public void setFormat(ExcelFormat format) {
        this.format = format;
    }

    public void setSheetIndex(int sheetIndex) {
        this.sheetIndex = sheetIndex;
        this.setSheet(null);
    }

    @Override
    public void setReader(Reader aReader) throws IOException {
        throw new UnsupportedOperationException("InputStream required");
    }

    @Override
    public void setStream(InputStream aReader) throws IOException {
        this.stream = aReader;
    }

    @Override
    public ExcelRow readLine() throws IOException {
        this.init();
        if (this.rowIterator.hasNext()) {
            return new ExcelRow(this.rowIterator.next());
        }
        return null;
    }

    protected void init() throws IOException, ImporterException {
        if (this.rowIterator != null) {
            return;
        }
        if (this.workbook == null) {
            if (this.format == null) {
                this.workbook = new HSSFWorkbook(this.stream);
            } else {
                switch (this.format) {
                    case XSSF: {
                        this.workbook = new XSSFWorkbook(this.stream);
                        break;
                    }
                    case SXSSF: {
                        this.workbook = new SXSSFWorkbook(new XSSFWorkbook(this.stream));
                        break;
                    }
                    case HSSF: {
                        this.workbook = new HSSFWorkbook(this.stream);
                    }
                }
            }
        }
        if (this.sheet == null) {
            if (this.sheetName != null) {
                this.sheet = this.workbook.getSheet(this.sheetName);
                if (this.sheet == null) {
                    throw new ImporterException("Sheet not found by name: " + this.getSheetName(), true);
                }
            } else {
                this.sheet = this.workbook.getSheetAt(this.sheetIndex);
            }
        }
        this.rowIterator = this.sheet.rowIterator();
    }

    @Override
    public void close() throws IOException {
        if (!this.keepOpen && this.stream != null) {
            this.stream.close();
        }
    }

    public Iterator<Row> getRowIterator() {
        return this.rowIterator;
    }

    public void setRowIterator(Iterator<Row> rowIterator) {
        this.rowIterator = rowIterator;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
        this.setRowIterator(null);
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
        this.setSheet(null);
    }

    public InputStream getStream() {
        return this.stream;
    }

    public void removeCurrentRow(LineImportProcessor processor) {
        this.rowIterator.remove();
        ExcelRow line = (ExcelRow)processor.getCurrentLine();
        this.sheet.removeRow(line.getRow());
    }

    public void removeColumn(int columnNum) {
        int maxColumn = 0;
        for (int r = 0; r < this.sheet.getLastRowNum() + 1; ++r) {
            Row row = this.sheet.getRow(r);
            if (row == null) continue;
            int lastColumn = row.getLastCellNum();
            if (lastColumn > maxColumn) {
                maxColumn = lastColumn;
            }
            if (lastColumn < columnNum) continue;
            for (int x = columnNum + 1; x < lastColumn + 1; ++x) {
                Cell nextCell;
                Cell oldCell = row.getCell(x - 1);
                if (oldCell != null) {
                    row.removeCell(oldCell);
                }
                if ((nextCell = row.getCell(x)) == null) continue;
                Cell newCell = row.createCell(x - 1, nextCell.getCellTypeEnum());
                ExcelRowReader.cloneCell(newCell, nextCell);
            }
        }
        for (int c = 0; c < maxColumn; ++c) {
            this.sheet.setColumnWidth(c, this.sheet.getColumnWidth(c + 1));
        }
    }

    private static void cloneCell(Cell cNew, Cell cOld) {
        cNew.setCellComment(cOld.getCellComment());
        cNew.setCellStyle(cOld.getCellStyle());
        switch (cNew.getCellTypeEnum()) {
            case BOOLEAN: {
                cNew.setCellValue(cOld.getBooleanCellValue());
                break;
            }
            case NUMERIC: {
                cNew.setCellValue(cOld.getNumericCellValue());
                break;
            }
            case STRING: {
                cNew.setCellValue(cOld.getStringCellValue());
                break;
            }
            case ERROR: {
                cNew.setCellValue((double)cOld.getErrorCellValue());
                break;
            }
            case FORMULA: {
                cNew.setCellFormula(cOld.getCellFormula());
            }
        }
    }
}

