/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.utility.fileimport.spreadsheet;

import com.agimatec.utility.fileimport.ImporterException;
import com.agimatec.utility.fileimport.spreadsheet.ExcelFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public abstract class ExcelGenerator {
    protected ExcelFormat format = ExcelFormat.HSSF;
    protected Workbook wb;
    protected Styles styles;
    protected static final String STYLE_boldTitle = "boldTitle";
    protected static final String STYLE_boldHeader = "boldHeader";
    protected static final String STYLE_redCell = "redCell";
    protected static final String STYLE_blueCell = "blueCell";

    public ExcelFormat getFormat() {
        return this.format;
    }

    public void setFormat(ExcelFormat format) {
        this.format = format;
    }

    public Workbook generateWorkbook() {
        this.initWorkbook();
        this.initStyles();
        this.generateSheets();
        return this.wb;
    }

    protected abstract void generateSheets();

    protected void initWorkbook() {
        switch (this.format) {
            case HSSF: {
                this.wb = new HSSFWorkbook();
                break;
            }
            case XSSF: {
                this.wb = new XSSFWorkbook();
                break;
            }
            case SXSSF: {
                this.wb = new SXSSFWorkbook();
            }
        }
    }

    protected void initStyles() {
        this.styles = new Styles();
    }

    public Workbook getWb() {
        return this.wb;
    }

    public Styles getStyles() {
        return this.styles;
    }

    protected CellStyle style(String name) {
        return this.getStyles().get(name);
    }

    protected Cell createCell(Row row, int column, Object value, CellStyle style) {
        Cell cell = this.createCell(row, column, value);
        if (style != null) {
            cell.setCellStyle(style);
        }
        return cell;
    }

    protected Cell createCell(Row row, int column, Object value) {
        Cell cell = row.createCell(column);
        if (value instanceof String) {
            cell.setCellValue((String)value);
        } else if (value instanceof Enum) {
            cell.setCellValue(((Enum)value).name());
        } else if (value instanceof Calendar) {
            cell.setCellValue((Calendar)value);
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else if (value instanceof Number) {
            cell.setCellValue(((Number)value).doubleValue());
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof RichTextString) {
            cell.setCellValue((RichTextString)value);
        } else if (value != null) {
            throw new RuntimeException("Unsupported cell value " + value);
        }
        return cell;
    }

    protected void createHeaders(Row row, int column, CellStyle style, String ... headers) {
        int i = 0;
        for (String header : headers) {
            this.createCell(row, column + i, header, style);
            ++i;
        }
    }

    public class Styles {
        protected Map<String, CellStyle> styles = new ConcurrentHashMap<String, CellStyle>();

        public CellStyle get(String name) {
            if (!this.styles.containsKey(name)) {
                try {
                    CellStyle style = (CellStyle)this.getClass().getMethod(name, new Class[0]).invoke((Object)this, new Object[0]);
                    this.put(name, style);
                    return style;
                }
                catch (Exception e) {
                    throw new ImporterException("Cannot create style " + name, e, true);
                }
            }
            return this.styles.get(name);
        }

        public void put(String name, CellStyle style) {
            this.styles.put(name, style);
        }

        public void clean() {
            this.styles.clear();
        }

        public CellStyle boldTitle() {
            CellStyle style = ExcelGenerator.this.wb.createCellStyle();
            Font font = ExcelGenerator.this.wb.createFont();
            font.setBold(true);
            font.setFontHeightInPoints((short)14);
            style.setFont(font);
            return style;
        }

        public CellStyle boldHeader() {
            CellStyle style = ExcelGenerator.this.wb.createCellStyle();
            Font font = ExcelGenerator.this.wb.createFont();
            font.setBold(true);
            font.setFontHeightInPoints((short)10);
            style.setFont(font);
            return style;
        }

        public CellStyle redCell() {
            CellStyle style = ExcelGenerator.this.wb.createCellStyle();
            Font font = ExcelGenerator.this.wb.createFont();
            font.setColor(IndexedColors.RED.getIndex());
            font.setFontHeightInPoints((short)10);
            style.setFont(font);
            return style;
        }

        public CellStyle blueCell() {
            CellStyle style = ExcelGenerator.this.wb.createCellStyle();
            Font font = ExcelGenerator.this.wb.createFont();
            font.setColor(IndexedColors.BLUE.getIndex());
            font.setFontHeightInPoints((short)10);
            style.setFont(font);
            return style;
        }
    }
}

