/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.utility.fileimport;

import com.agimatec.utility.fileimport.ImportControl;
import com.agimatec.utility.fileimport.ImportController;
import com.agimatec.utility.fileimport.Importer;
import com.agimatec.utility.fileimport.ImporterSpec;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;

public class ImportJob {
    public static int MAX_LENGTH = 1000;
    protected static final String C_ProtocolClassPath = "cp://";
    protected final ImportControl control = new ImportControl();
    protected Connection connection;
    protected ImportController controller;
    protected Importer importer;
    protected InputStream readStream;

    public ImportJob() {
    }

    public ImportJob(Connection connection) {
        this.connection = connection;
    }

    public static URL toURL(String path) throws MalformedURLException {
        if (path.startsWith(C_ProtocolClassPath)) {
            String theResPath = path.substring(C_ProtocolClassPath.length());
            return ImportJob.getClassLoader().getResource(theResPath);
        }
        if (path.indexOf(58) < 0) {
            return new URL("file:" + path);
        }
        return new URL(path);
    }

    private static ClassLoader getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ImportJob.class.getClassLoader();
        }
        return loader;
    }

    public void importFromURL(ImporterSpec spec) throws Exception {
        this.importFromReader(spec, "UTF-8");
    }

    public void importFromStream(ImporterSpec spec) throws Exception {
        this.openURL(spec);
        try {
            this.importer.importFrom(this.readStream);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFromReader(ImporterSpec spec, String charset) throws Exception {
        this.openURL(spec);
        try {
            this.importer.importFrom(new InputStreamReader(this.readStream, Charset.forName(charset)));
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        finally {
            this.close();
        }
    }

    protected void handleException(Exception ex) throws Exception {
        this.handleErrorMessage(ex);
        throw ex;
    }

    protected void handleErrorMessage(Exception ex) {
        this.control.setErrorMessage(ex.getMessage());
        if (this.control.getErrorMessage().length() > MAX_LENGTH) {
            this.control.setErrorMessage(this.control.getErrorMessage().substring(0, MAX_LENGTH));
        }
    }

    protected void openURL(ImporterSpec spec) throws IOException {
        this.importer = new Importer(spec);
        this.readStream = ImportJob.toURL(this.control.getFileName()).openStream();
    }

    protected void close() throws SQLException, IOException {
        if (this.importer != null && this.controller != null) {
            this.controller.end(this.control, this.importer);
        }
        if (this.readStream != null) {
            this.readStream.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public void join() throws SQLException {
        this.controller.join(this.control);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public ImportController getController() {
        return this.controller;
    }

    public ImportControl getControl() {
        return this.control;
    }

    public Importer getImporter() {
        return this.importer;
    }

    public void setController(ImportController controller) {
        this.controller = controller;
    }

    public void setImporter(Importer importer) {
        this.importer = importer;
    }
}

