/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.utility.fileimport.spreadsheet;

import com.agimatec.utility.fileimport.spreadsheet.ICell;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelUtils {
    public static String getString(Map<String, ICell> row, String colName) {
        ICell cell = row.get(colName);
        if (cell != null) {
            return cell.getStringValue();
        }
        return null;
    }

    public static boolean getBoolean(Map<String, ICell> row, String columnName) {
        ICell cell = row.get(columnName);
        if (cell == null) {
            return false;
        }
        Object value = cell.getValue();
        if (value instanceof Boolean) {
            return (Boolean)cell.getValue();
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        if (value != null) {
            String content = cell.getStringValue().trim();
            return "1".equalsIgnoreCase(content) || "yes".equalsIgnoreCase(content) || "true".equalsIgnoreCase(content);
        }
        return false;
    }

    public static Integer getInteger(Map<String, ICell> row, String columnName) {
        ICell cell = row.get(columnName);
        if (cell == null) {
            return null;
        }
        Object val = cell.getValue();
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        return null;
    }

    public static Long getLong(Map<String, ICell> row, String columnName) {
        ICell cell = row.get(columnName);
        if (cell == null) {
            return null;
        }
        Object val = cell.getValue();
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        return null;
    }

    public static Double getDouble(Map<String, ICell> row, String columnName) {
        ICell cell = row.get(columnName);
        if (cell == null) {
            return null;
        }
        Object val = cell.getValue();
        if (val == null) {
            return null;
        }
        return cell.getNumericValue();
    }
}

