/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.utility.fileimport.spreadsheet;

import com.agimatec.utility.fileimport.Importer;
import com.agimatec.utility.fileimport.LineImportProcessor;
import com.agimatec.utility.fileimport.LineImporterSpec;
import com.agimatec.utility.fileimport.spreadsheet.ExcelUtils;
import com.agimatec.utility.fileimport.spreadsheet.ICell;
import java.sql.Time;
import java.util.Date;
import java.util.Map;

public class ExcelImportProcessor
extends LineImportProcessor {
    public ExcelImportProcessor(LineImporterSpec spec, Importer importer) {
        super(spec, importer);
    }

    public String getString(String colName) {
        Map row = this.getCurrentRow();
        return ExcelUtils.getString(row, colName);
    }

    public boolean getBoolean(String colName) {
        Map row = this.getCurrentRow();
        return ExcelUtils.getBoolean(row, colName);
    }

    public Integer getInteger(String colName) {
        Map row = this.getCurrentRow();
        return ExcelUtils.getInteger(row, colName);
    }

    public Long getLong(String colName) {
        Map row = this.getCurrentRow();
        return ExcelUtils.getLong(row, colName);
    }

    public Time getTime(String colName) {
        Map row = this.getCurrentRow();
        ICell cell = (ICell)row.get(colName);
        if (cell == null) {
            return null;
        }
        Date date = cell.getDateValue();
        return date != null ? new Time(date.getTime()) : null;
    }

    public Double getDouble(String colName) {
        Map row = this.getCurrentRow();
        return ExcelUtils.getDouble(row, colName);
    }
}

