/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.utility.fileimport.spreadsheet;

import com.agimatec.utility.fileimport.spreadsheet.ICell;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;

public class ExcelCell
implements ICell {
    private final DecimalFormat plainNumericFormat = new DecimalFormat("#.#");
    private final Cell cell;
    private CellStyle style;

    public ExcelCell(Cell excelCell) {
        this.cell = excelCell;
        this.plainNumericFormat.setGroupingUsed(false);
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        this.plainNumericFormat.setDecimalFormatSymbols(dfs);
    }

    public String toString() {
        return this.getStringValue();
    }

    public Object getValue() {
        return this.getValue(this.cell.getCellTypeEnum());
    }

    private Object getValue(CellType cellType) {
        switch (cellType) {
            case NUMERIC: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)this.cell)) {
                    return this.cell.getDateCellValue();
                }
                return this.cell.getNumericCellValue();
            }
            case FORMULA: {
                return this.getValue(this.cell.getCachedFormulaResultTypeEnum());
            }
            case BOOLEAN: {
                return this.cell.getBooleanCellValue();
            }
            case STRING: {
                return this.cell.getRichStringCellValue().getString();
            }
            case ERROR: {
                return this.cell.getErrorCellValue();
            }
        }
        return null;
    }

    public double getNumericValue() {
        return this.toNumericValue(this.getValue());
    }

    private double toNumericValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringValue() {
        Object val = this.getValue();
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            return (String)val;
        }
        if (val instanceof Double) {
            DecimalFormat decimalFormat = this.plainNumericFormat;
            synchronized (decimalFormat) {
                return this.plainNumericFormat.format(val);
            }
        }
        return String.valueOf(val);
    }

    public Date getDateValue() {
        if (this.cell.getCellTypeEnum() == CellType.NUMERIC || this.cell.getCellTypeEnum() == CellType.FORMULA) {
            try {
                return this.cell.getDateCellValue();
            }
            catch (NullPointerException ex) {
                return null;
            }
        }
        return null;
    }

    public CellStyle getStyle() {
        if (this.style == null) {
            this.style = this.cell.getCellStyle();
        }
        return this.style;
    }

    public Cell getCell() {
        return this.cell;
    }

    public String getComment() {
        Comment comment = this.cell.getCellComment();
        if (comment != null) {
            return comment.getString().getString();
        }
        return null;
    }

    public int getColumnIndex() {
        return this.cell.getColumnIndex();
    }
}

