/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.utility.fileimport;

import com.agimatec.utility.fileimport.Importer;
import com.agimatec.utility.fileimport.ImporterException;
import com.agimatec.utility.fileimport.ImporterSpec;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public abstract class ImporterProcessor {
    protected final Importer importer;
    private Writer errorWriter;
    protected int errorCount;
    protected int rowCount;
    protected boolean cancelled = false;
    protected Object lastError;

    protected abstract ImporterSpec getSpec();

    protected ImporterProcessor(Importer importer) {
        this.importer = importer;
    }

    public Importer getImporter() {
        return this.importer;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public Object getLastError() {
        return this.lastError;
    }

    public void setLastError(Object lastError) {
        this.lastError = lastError;
    }

    public Writer getErrorWriter() throws IOException {
        if (this.errorWriter == null) {
            Writer theWriter = this.getSpec().getErrorWriter();
            if (theWriter == null) {
                this.errorWriter = new OutputStreamWriter(System.err);
            } else {
                return theWriter;
            }
        }
        return this.errorWriter;
    }

    public void setErrorWriter(Writer aErrorWriter) {
        this.errorWriter = aErrorWriter;
    }

    public void log(Object obj) {
        this.importer.log(obj);
    }

    protected void importFrom(Closeable aReader) {
        this.errorCount = 0;
        this.rowCount = 0;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    protected void logFinished() {
        this.importer.log("Done. Rows/errors = " + this.rowCount + "/" + this.errorCount);
    }

    public void release() {
        try {
            if (this.errorWriter != null) {
                this.errorWriter.close();
            }
        }
        catch (Exception ex) {
            this.importer.log(ex);
        }
        this.errorWriter = null;
    }

    protected void handleException(Exception ex) throws ImporterException {
        if (ex != null) {
            this.setLastError(ex);
        }
        if (ex instanceof ImporterException) {
            if (((ImporterException)ex).isCancelImport()) {
                this.cancelled = true;
            }
            throw (ImporterException)ex;
        }
        this.cancelled = true;
        throw new ImporterException(ex, true);
    }

    protected void handleRowException(Exception iex, Object aLine) {
        if (iex instanceof ImporterException && ((ImporterException)iex).isCancelImport()) {
            this.cancelled = true;
        }
        ++this.errorCount;
        this.setLastError(iex);
        this.importer.log("'" + aLine + "' caused exception:");
        this.importer.log(iex);
        try {
            this.getErrorWriter().write(String.valueOf(aLine));
            this.getErrorWriter().write(10);
        }
        catch (Exception ex) {
            this.importer.log(ex);
        }
    }
}

