/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.utility.fileimport.spreadsheet;

import com.agimatec.utility.fileimport.ImporterException;
import com.agimatec.utility.fileimport.LineImportProcessor;
import com.agimatec.utility.fileimport.LineReader;
import com.agimatec.utility.fileimport.spreadsheet.ExcelRow;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFAccess;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelRowReader
implements LineReader<ExcelRow> {
    private int sheetIndex = 0;
    private POIFSFileSystem fileSystem;
    private HSSFWorkbook workbook;
    private HSSFSheet sheet;
    private Iterator<Row> rowIterator;
    private InputStream stream;
    private String sheetName;
    private final boolean keepOpen;

    public ExcelRowReader(boolean keepOpen) {
        this.keepOpen = keepOpen;
    }

    public ExcelRowReader() {
        this.keepOpen = false;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
        this.setSheet(null);
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public boolean isKeepOpen() {
        return this.keepOpen;
    }

    public void setSheetIndex(int sheetIndex) {
        this.sheetIndex = sheetIndex;
        this.setSheet(null);
    }

    @Override
    public void setReader(Reader aReader) throws IOException {
        throw new UnsupportedOperationException("InputStream required");
    }

    @Override
    public void setStream(InputStream aReader) throws IOException {
        this.stream = aReader;
    }

    @Override
    public ExcelRow readLine() throws IOException {
        this.init();
        if (this.rowIterator.hasNext()) {
            return new ExcelRow(this.rowIterator.next());
        }
        return null;
    }

    protected void init() throws IOException, ImporterException {
        if (this.rowIterator != null) {
            return;
        }
        if (this.fileSystem == null) {
            this.fileSystem = new POIFSFileSystem(this.stream);
        }
        if (this.workbook == null) {
            this.workbook = new HSSFWorkbook(this.fileSystem);
        }
        if (this.sheet == null) {
            if (this.sheetName != null) {
                this.sheet = this.workbook.getSheet(this.sheetName);
                if (this.sheet == null) {
                    throw new ImporterException("Sheet not found by name: " + this.getSheetName(), true);
                }
            } else {
                this.sheet = this.workbook.getSheetAt(this.sheetIndex);
            }
        }
        this.rowIterator = this.sheet.rowIterator();
    }

    @Override
    public void close() throws IOException {
        if (!this.keepOpen && this.stream != null) {
            this.stream.close();
        }
    }

    public POIFSFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public void setFileSystem(POIFSFileSystem fileSystem) {
        this.fileSystem = fileSystem;
        this.setWorkbook(null);
    }

    public Iterator<Row> getRowIterator() {
        return this.rowIterator;
    }

    public void setRowIterator(Iterator<Row> rowIterator) {
        this.rowIterator = rowIterator;
    }

    public HSSFSheet getSheet() {
        return this.sheet;
    }

    public void setSheet(HSSFSheet sheet) {
        this.sheet = sheet;
        this.setRowIterator(null);
    }

    public HSSFWorkbook getWorkbook() {
        return this.workbook;
    }

    public void setWorkbook(HSSFWorkbook workbook) {
        this.workbook = workbook;
        this.setSheet(null);
    }

    public InputStream getStream() {
        return this.stream;
    }

    public void removeCurrentRow(LineImportProcessor processor) {
        this.rowIterator.remove();
        ExcelRow line = (ExcelRow)processor.getCurrentLine();
        HSSFAccess.getInternalSheet(this.sheet).removeRow(HSSFAccess.getRowRecord((HSSFRow)line.getRow()));
    }

    public void removeColumn(int columnNum) {
        int maxColumn = 0;
        for (int r = 0; r < this.sheet.getLastRowNum() + 1; ++r) {
            HSSFRow row = this.sheet.getRow(r);
            if (row == null) continue;
            int lastColumn = row.getLastCellNum();
            if (lastColumn > maxColumn) {
                maxColumn = lastColumn;
            }
            if (lastColumn < columnNum) continue;
            for (int x = columnNum + 1; x < lastColumn + 1; ++x) {
                Cell nextCell;
                Cell oldCell = row.getCell(x - 1);
                if (oldCell != null) {
                    row.removeCell(oldCell);
                }
                if ((nextCell = row.getCell(x)) == null) continue;
                Cell newCell = row.createCell(x - 1, nextCell.getCellType());
                ExcelRowReader.cloneCell(newCell, nextCell);
            }
        }
        for (int c = 0; c < maxColumn; ++c) {
            this.sheet.setColumnWidth(c, this.sheet.getColumnWidth(c + 1));
        }
    }

    private static void cloneCell(Cell cNew, Cell cOld) {
        cNew.setCellComment(cOld.getCellComment());
        cNew.setCellStyle(cOld.getCellStyle());
        switch (cNew.getCellType()) {
            case 4: {
                cNew.setCellValue(cOld.getBooleanCellValue());
                break;
            }
            case 0: {
                cNew.setCellValue(cOld.getNumericCellValue());
                break;
            }
            case 1: {
                cNew.setCellValue(cOld.getStringCellValue());
                break;
            }
            case 5: {
                cNew.setCellValue((double)cOld.getErrorCellValue());
                break;
            }
            case 2: {
                cNew.setCellFormula(cOld.getCellFormula());
            }
        }
    }
}

