/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.utility.fileimport.groovy;

import com.agimatec.utility.fileimport.Importer;
import com.agimatec.utility.fileimport.ImporterException;
import com.agimatec.utility.fileimport.ImporterProcessor;
import com.agimatec.utility.fileimport.groovy.XmlSlurperSpec;
import groovy.util.XmlSlurper;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;

public class XmlImportProcessor
extends ImporterProcessor {
    protected final XmlSlurperSpec spec;
    protected XmlSlurper xmlSlurper;
    protected Object current;

    public XmlImportProcessor(XmlSlurperSpec spec, Importer importer) {
        super(importer);
        this.spec = spec;
    }

    public XmlSlurperSpec getSpec() {
        return this.spec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFrom(Closeable aReader) throws ImporterException {
        super.importFrom(aReader);
        try {
            this.xmlSlurper = new XmlSlurper();
            try {
                this.current = aReader instanceof InputStream ? this.xmlSlurper.parse((InputStream)aReader) : this.xmlSlurper.parse((Reader)aReader);
                this.spec.processFirst(this);
                Iterator iter = this.spec.iterator(this);
                while (iter.hasNext() && !this.isCancelled()) {
                    ++this.rowCount;
                    this.current = iter.next();
                    this.importEach();
                }
            }
            finally {
                aReader.close();
                this.release();
                this.logFinished();
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void importEach() throws ImporterException {
        try {
            this.spec.processEach(this);
        }
        catch (ImporterException ex) {
            this.handleRowException(ex, this.current);
            if (ex.isCancelImport()) {
                throw ex;
            }
        }
        catch (Exception ex) {
            this.handleRowException(ex, this.current);
        }
    }

    public void release() {
        super.release();
        this.current = null;
    }

    public Object getCurrent() {
        return this.current;
    }

    public XmlSlurper getXmlSlurper() {
        return this.xmlSlurper;
    }
}

