/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.utility.fileimport;

import java.io.Serializable;
import java.lang.constant.Constable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

public class SqlUtil
implements Serializable {
    private static final String[] SEQ = new String[]{"nextval(''{0}'')", "{0}.NEXTVAL", "NEXT VALUE FOR {0}"};
    private static final String[] SEQ_FETCH = new String[]{"SELECT {0}", "SELECT {0} FROM DUAL", "SELECT {0}"};
    private static final int POSTGRES = 0;
    private static final int ORACLE = 1;
    private static final int HSQLDB = 2;
    private final int dbms;
    private Map<String, Object> calls = new HashMap<String, Object>();

    public static SqlUtil forConnection(Connection connection) throws SQLException {
        String dbms = connection.getMetaData().getDatabaseProductName();
        if ("Oracle".equals(dbms)) {
            return SqlUtil.forOracle();
        }
        if ("PostgreSQL".equals(dbms)) {
            return SqlUtil.forPostgres();
        }
        return SqlUtil.getDefault();
    }

    public boolean isOracle() {
        return this.dbms == 1;
    }

    public boolean isPostgres() {
        return this.dbms == 0;
    }

    public boolean isHSQLDB() {
        return this.dbms == 2;
    }

    public static SqlUtil forPostgres() {
        return new SqlUtil(0);
    }

    public static SqlUtil forOracle() {
        return new SqlUtil(1);
    }

    public static SqlUtil forHSQLDB() {
        return new SqlUtil(2);
    }

    public static SqlUtil getDefault() {
        return SqlUtil.forPostgres();
    }

    protected SqlUtil(int dbms) {
        this.dbms = dbms;
    }

    public void defDate(String fieldname, String dateFormat) {
        this.calls.put(fieldname, new SimpleDateFormat(dateFormat));
    }

    public void defNumber(String fieldname, String numberFormat) {
        this.calls.put(fieldname, new DecimalFormat(numberFormat));
    }

    public void defSequence(String fieldname, String sequenceName) {
        this.calls.put(fieldname, MessageFormat.format(SEQ[this.dbms], sequenceName));
    }

    public Date date(String fieldName, String value) throws ParseException {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        Object def = this.calls.get(fieldName);
        return new Date(((DateFormat)def).parse(value).getTime());
    }

    public Timestamp timestamp(String fieldName, String value) throws ParseException {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        Object def = this.calls.get(fieldName);
        return new Timestamp(((DateFormat)def).parse(value).getTime());
    }

    public Time time(String fieldName, String value) throws ParseException {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        Object def = this.calls.get(fieldName);
        return new Time(((DateFormat)def).parse(value).getTime());
    }

    public Number number(String fieldName, String value) throws ParseException {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        Object def = this.calls.get(fieldName);
        return ((NumberFormat)def).parse(value);
    }

    public boolean isTrue(String value) {
        return "1".equals(value) || Boolean.parseBoolean(value);
    }

    public Object bool(String value) {
        if (value == null) {
            return null;
        }
        return this.isOracle() ? (Constable)Integer.valueOf(this.isTrue(value) ? 1 : 0) : (Constable)Boolean.valueOf(this.isTrue(value));
    }

    public Object bool(boolean value) {
        return this.isOracle() ? (Constable)Integer.valueOf(value ? 1 : 0) : (Constable)Boolean.valueOf(value);
    }

    public String nullable(String value) {
        return value == null || value.length() == 0 ? null : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextVal(Connection connection, String fieldName) throws SQLException {
        String sql = MessageFormat.format(SEQ_FETCH[this.dbms], this.get(fieldName));
        Statement stmt = connection.createStatement();
        ResultSet result = null;
        try {
            result = stmt.executeQuery(sql);
            result.next();
            long l = result.getLong(1);
            return l;
        }
        finally {
            if (result != null) {
                result.close();
            }
            stmt.close();
        }
    }

    public Object get(String fieldName) {
        return this.calls.get(fieldName);
    }

    public String trim(String value) {
        return value == null ? value : this.nullable(value.trim());
    }
}

