/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.utility.fileimport;

import com.agimatec.utility.fileimport.ImportControl;
import com.agimatec.utility.fileimport.ImportState;
import com.agimatec.utility.fileimport.Importer;
import com.agimatec.utility.fileimport.SqlUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportController {
    private static final Logger log = LoggerFactory.getLogger(ImportController.class);
    protected Connection connection;
    protected SqlUtil sqlUtil;
    protected String selectAll;
    protected String selectByName;
    protected String selectById;
    protected String insert;
    protected String lockByName;
    protected String update;
    protected String deleteByName;
    protected String deleteById;

    private void initStatements() {
        this.lockByName = "UPDATE Import_Control SET STATUS=STATUS where import_name=?";
        this.selectAll = "SELECT import_id,start_time,end_time,status,row_count,error_count,description,file_name,import_name FROM Import_Control ORDER BY import_id";
        this.selectByName = "SELECT import_id,start_time,end_time,status,row_count,error_count,description,file_name,import_name FROM Import_Control WHERE import_name = ? ORDER BY import_id";
        this.selectById = "SELECT import_id,start_time,end_time,status,row_count,error_count,description,file_name,import_name FROM Import_Control WHERE import_id = ?";
        this.insert = "INSERT INTO Import_Control (start_time, end_time, status, import_name, description, file_name, import_id) VALUES (?, ?, ?, ?, ?, ?, ?)";
        this.update = "UPDATE Import_Control SET end_time = ?, status = ?, row_count = ?, error_count = ?, error_message = ? WHERE import_id = ?";
        this.deleteByName = "DELETE FROM Import_Control WHERE Import_Name = ?";
        this.deleteById = "DELETE FROM Import_Control WHERE Import_Id = ?";
    }

    public ImportController(Connection connection, SqlUtil util) {
        this.connection = connection;
        this.sqlUtil = util;
        this.initStatements();
    }

    public ImportController(Connection connection, SqlUtil util, String sequenceName) {
        this.connection = connection;
        this.sqlUtil = util;
        util.defSequence("import_id", sequenceName);
        this.initStatements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ImportControl> findAll() throws SQLException {
        PreparedStatement selectStmt = this.connection.prepareStatement(this.selectAll);
        try {
            ResultSet result = selectStmt.executeQuery();
            ArrayList<ImportControl> rows = new ArrayList<ImportControl>();
            while (result.next()) {
                rows.add(this.createInstance(result));
            }
            result.close();
            ArrayList<ImportControl> arrayList = rows;
            return arrayList;
        }
        finally {
            selectStmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ImportControl> findByName(String importName) throws SQLException {
        PreparedStatement selectStmt = this.connection.prepareStatement(this.selectByName);
        try {
            selectStmt.setString(1, importName);
            ResultSet result = selectStmt.executeQuery();
            ArrayList<ImportControl> rows = new ArrayList<ImportControl>();
            while (result.next()) {
                rows.add(this.createInstance(result));
            }
            result.close();
            ArrayList<ImportControl> arrayList = rows;
            return arrayList;
        }
        finally {
            selectStmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportControl findById(long importId) throws SQLException {
        PreparedStatement selectStmt = this.connection.prepareStatement(this.selectById);
        try {
            selectStmt.setLong(1, importId);
            ResultSet result = selectStmt.executeQuery();
            ImportControl row = null;
            if (result.next()) {
                row = this.createInstance(result);
            }
            result.close();
            ImportControl importControl = row;
            return importControl;
        }
        finally {
            selectStmt.close();
        }
    }

    private ImportControl createInstance(ResultSet result) throws SQLException {
        ImportControl row = new ImportControl();
        row.importId = result.getLong(1);
        row.startTime = result.getTimestamp(2);
        row.endTime = result.getTimestamp(3);
        String str = result.getString(4);
        if (str != null) {
            row.status = ImportState.valueOf(str);
        }
        row.rowCount = result.getInt(5);
        if (result.wasNull()) {
            row.rowCount = null;
        }
        row.errorCount = result.getInt(6);
        if (result.wasNull()) {
            row.errorCount = null;
        }
        row.description = result.getString(7);
        row.fileName = result.getString(8);
        row.importName = result.getString(9);
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String importName) throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement(this.deleteByName);
        try {
            stmt.setString(1, importName);
            boolean bl = stmt.executeUpdate() > 0;
            return bl;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(long importId) throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement(this.deleteById);
        try {
            stmt.setLong(1, importId);
            boolean bl = stmt.executeUpdate() > 0;
            return bl;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock(String importName) throws SQLException {
        if (log.isInfoEnabled()) {
            log.info("Aquire lock for import '" + importName + "'...");
        }
        PreparedStatement stmt = this.connection.prepareStatement(this.lockByName);
        try {
            stmt.setString(1, importName);
            boolean bl = stmt.executeUpdate() > 0;
            return bl;
        }
        finally {
            stmt.close();
        }
    }

    public ImportControl join(String importName) throws SQLException {
        ImportControl imp = new ImportControl();
        imp.importName = importName;
        this.join(imp);
        return imp;
    }

    public long join(ImportControl imp) throws SQLException {
        this.lock(imp.importName);
        return this.start(imp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ImportControl imp) throws SQLException {
        PreparedStatement updateStmt = this.connection.prepareStatement(this.update);
        try {
            this.setUpdateParameters(updateStmt, imp);
            if (updateStmt.executeUpdate() == 0) {
                this.start(imp);
                this.setUpdateParameters(updateStmt, imp);
                if (imp.rowCount != null || imp.errorCount != null) {
                    updateStmt.executeUpdate();
                }
            }
        }
        finally {
            updateStmt.close();
        }
    }

    public void update(ImportControl imp, Importer importer) throws SQLException {
        imp.errorMessage = importer.getLastErrorMessage();
        imp.rowCount = importer.getRowCount();
        imp.errorCount = importer.getErrorCount();
        this.update(imp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long start(ImportControl imp) throws SQLException {
        if (imp.importId == 0L) {
            imp.importId = this.sqlUtil.nextVal(this.connection, "import_id");
        }
        if (log.isInfoEnabled()) {
            log.info("Starting import '" + imp.importName + "' (" + imp.importId + ")...");
        }
        PreparedStatement insertStmt = null;
        try {
            insertStmt = this.connection.prepareStatement(this.insert);
            if (imp.startTime == null) {
                imp.startTime = ImportController.now();
            }
            imp.endTime = null;
            if (imp.status == null) {
                imp.status = ImportState.RUNNING;
            }
            this.setParameters(insertStmt, imp);
            insertStmt.execute();
        }
        finally {
            if (insertStmt != null) {
                insertStmt.close();
            }
        }
        return imp.getImportId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(ImportControl imp) throws SQLException {
        PreparedStatement updateStmt = this.connection.prepareStatement(this.update);
        try {
            if (imp.endTime == null) {
                imp.endTime = ImportController.now();
            }
            this.setUpdateParameters(updateStmt, imp);
            if (updateStmt.executeUpdate() == 0) {
                this.start(imp);
                this.setUpdateParameters(updateStmt, imp);
                if (imp.rowCount != null || imp.errorCount != null) {
                    updateStmt.executeUpdate();
                }
            }
        }
        finally {
            updateStmt.close();
        }
    }

    public void end(long importId, Importer importer) throws SQLException {
        ImportControl imp = this.findById(importId);
        this.end(imp, importer);
    }

    public void end(ImportControl imp, Importer importer) throws SQLException {
        ImportState status;
        ImportState importState = status = importer.isCancelled() ? ImportState.CANCELLED : ImportState.DONE;
        if (log.isInfoEnabled()) {
            log.info((Object)((Object)status) + ": Import (" + imp.getImportId() + ") '" + imp.getImportName() + "' has finished " + importer.getRowCount() + " rows with " + importer.getErrorCount() + " errors.");
        }
        imp.rowCount = importer.getRowCount();
        imp.errorCount = importer.getErrorCount();
        imp.status = status;
        this.end(imp);
    }

    private void setUpdateParameters(PreparedStatement updateStmt, ImportControl imp) throws SQLException {
        updateStmt.setTimestamp(1, imp.endTime);
        updateStmt.setString(2, imp.status.name());
        updateStmt.setObject(3, imp.rowCount);
        updateStmt.setObject(4, imp.errorCount);
        String errmsg = imp.errorMessage;
        if (errmsg != null && errmsg.length() > 2000) {
            errmsg = errmsg.substring(0, 2000);
        }
        updateStmt.setString(5, errmsg);
        updateStmt.setLong(6, imp.importId);
    }

    private void setParameters(PreparedStatement stmt, ImportControl imp) throws SQLException {
        stmt.setTimestamp(1, imp.startTime);
        stmt.setTimestamp(2, imp.endTime);
        if (imp.status != null) {
            stmt.setString(3, imp.status.name());
        } else {
            stmt.setString(3, null);
        }
        stmt.setString(4, imp.importName);
        stmt.setString(5, imp.description);
        stmt.setString(6, imp.fileName);
        stmt.setLong(7, imp.importId);
    }

    public SqlUtil getSqlUtil() {
        return this.sqlUtil;
    }

    private static Timestamp now() {
        return new Timestamp(System.currentTimeMillis());
    }
}

