/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.utility.fileimport.spreadsheet;

import com.agimatec.utility.fileimport.Importer;
import com.agimatec.utility.fileimport.ImporterException;
import com.agimatec.utility.fileimport.ImporterProcessor;
import com.agimatec.utility.fileimport.LineImportProcessor;
import com.agimatec.utility.fileimport.LineImporterSpec;
import com.agimatec.utility.fileimport.LineImporterSpecAutoFields;
import com.agimatec.utility.fileimport.LineReader;
import com.agimatec.utility.fileimport.LineTokenizerFactory;
import com.agimatec.utility.fileimport.spreadsheet.ExcelCell;
import com.agimatec.utility.fileimport.spreadsheet.ExcelImportProcessor;
import com.agimatec.utility.fileimport.spreadsheet.ExcelRow;
import com.agimatec.utility.fileimport.spreadsheet.ExcelRowReader;
import com.agimatec.utility.fileimport.spreadsheet.SharedExcelRowReaderFactory;
import java.io.Closeable;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExcelImporterSpec
extends LineImporterSpecAutoFields {
    private final String sheetName;

    public ExcelImporterSpec(String sheetName) {
        this(sheetName, new SharedExcelRowReaderFactory());
    }

    public ExcelImporterSpec(String sheetName, LineTokenizerFactory<ExcelRow, ExcelCell> excelRowTokenizerFactory) {
        this.sheetName = sheetName;
        this.setLineTokenizerFactory(excelRowTokenizerFactory);
        this.setHeaderSpec(LineImporterSpec.Header.INDEX);
    }

    public String getSheetName() {
        return this.sheetName;
    }

    @Override
    public LineReader createLineReader(Closeable aReader) throws IOException {
        ExcelRowReader reader = (ExcelRowReader)super.createLineReader(aReader);
        reader.setSheetName(this.sheetName);
        return reader;
    }

    @Override
    public void processRow(LineImportProcessor processor) throws ImporterException {
        if (processor.getRowCount() > this.getHeaderLineIndex()) {
            this.processRow((ExcelImportProcessor)processor);
        }
    }

    protected abstract void processRow(ExcelImportProcessor var1);

    @Override
    public ImporterProcessor createProcessor(Importer importer) {
        return new ExcelImportProcessor(this, importer);
    }
}

