/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.utility.fileimport.spreadsheet;

import com.agimatec.utility.fileimport.ImporterException;
import com.agimatec.utility.fileimport.LineReader;
import com.agimatec.utility.fileimport.spreadsheet.ExcelRow;
import com.agimatec.utility.fileimport.spreadsheet.ExcelRowReader;
import com.agimatec.utility.fileimport.spreadsheet.ExcelRowTokenizerFactory;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedExcelRowReaderFactory
extends ExcelRowTokenizerFactory {
    private InputStream stream;
    private final boolean keepOpen;
    private ExcelRowReader sharedReader;

    public SharedExcelRowReaderFactory() {
        this.keepOpen = true;
    }

    public SharedExcelRowReaderFactory(InputStream stream, boolean keepOpen) {
        this.stream = stream;
        this.keepOpen = keepOpen;
    }

    @Override
    public LineReader<ExcelRow> createLineReader() {
        if (this.sharedReader == null) {
            this.sharedReader = new ExcelRowReader(this.keepOpen);
        } else {
            this.sharedReader.setRowIterator(null);
        }
        if (this.stream != null) {
            try {
                this.sharedReader.setStream(this.stream);
            }
            catch (IOException e) {
                throw new ImporterException(e, true);
            }
        }
        return this.sharedReader;
    }
}

