/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.utility.fileimport;

import com.agimatec.utility.fileimport.CSVStringTokenizerFactory;
import com.agimatec.utility.fileimport.ImporterException;
import com.agimatec.utility.fileimport.LineImportProcessor;
import com.agimatec.utility.fileimport.LineImporterSpec;
import com.agimatec.utility.fileimport.LineTokenizer;
import com.agimatec.utility.fileimport.spreadsheet.ICell;
import java.util.HashMap;

public class LineImporterSpecAutoFields
extends LineImporterSpec {
    public LineImporterSpecAutoFields() {
        this.setHeaderSpec(LineImporterSpec.Header.FIRST);
        this.setLineTokenizerFactory(new CSVStringTokenizerFactory());
    }

    public void processHeaderLine(LineImportProcessor processor) throws ImporterException {
        LineTokenizer tokens = this.getLineTokenizerFactory().createTokenizer(processor.getHeaderLine());
        HashMap<Integer, String> fieldNames = new HashMap<Integer, String>();
        int fieldIdx = -1;
        int maxFieldIdx = 0;
        while (tokens.hasMoreElements()) {
            Object val = tokens.nextElement();
            fieldIdx = val instanceof ICell ? ((ICell)val).getColumnIndex() : ++fieldIdx;
            fieldNames.put(fieldIdx, val == null ? null : String.valueOf(val));
            if (fieldIdx <= maxFieldIdx) continue;
            maxFieldIdx = fieldIdx;
        }
        String[] fieldNamesArr = new String[maxFieldIdx + 1];
        for (int i = 0; i <= maxFieldIdx; ++i) {
            fieldNamesArr[i] = (String)fieldNames.get(i);
        }
        this.setFieldNames(fieldNamesArr);
    }
}

