/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.annotations.jam;

import com.agimatec.annotations.TestMethodDocumentation;
import com.agimatec.annotations.jam.JAMTestAnnotatedElement;
import com.agimatec.annotations.jam.JAMTestClass;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jam.JAnnotatedElement;
import org.codehaus.jam.JClass;
import org.codehaus.jam.JField;
import org.codehaus.jam.JMethod;

public class JAMTestMethod
extends JAMTestAnnotatedElement {
    private final JMethod jmethod;
    private final JAMTestClass testClass;

    public JAMTestMethod(JMethod jmethod, JAMTestClass TestClass) {
        this.jmethod = jmethod;
        this.testClass = TestClass;
    }

    public JAMTestClass getTestClass() {
        return this.testClass;
    }

    protected JAnnotatedElement element() {
        return this.jmethod;
    }

    protected String singleAnnotation() {
        return TestMethodDocumentation.class.getName();
    }

    protected String multiAnnotation() {
        return TestMethodDocumentation.class.getName();
    }

    public String getName() {
        int offset = 3;
        if (this.getType().equals("boolean") && this.jmethod.getSimpleName().startsWith("is")) {
            offset = 2;
        }
        return StringUtils.uncapitalize((String)this.jmethod.getSimpleName().substring(offset));
    }

    public String getType() {
        return this.jmethod.getReturnType().getQualifiedName();
    }

    public JClass getTypeJClass() {
        return this.jmethod.getReturnType();
    }

    public String getType(String path) {
        if (path == null || path.length() == 0) {
            return this.getType();
        }
        StringTokenizer tokens = new StringTokenizer(path, ".");
        JClass current = this.jmethod.getReturnType();
        while (tokens.hasMoreTokens() && current != null) {
            String each = tokens.nextToken();
            JField field = JAMTestMethod.findField(current, each);
            current = field == null ? null : field.getType();
        }
        if (current == null) {
            return null;
        }
        return current.getQualifiedName();
    }

    public boolean isEnumType() {
        return this.jmethod.getReturnType().isEnumType();
    }
}

