/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.annotations.jam;

import com.agimatec.annotations.TestDocumentation;
import com.agimatec.annotations.TestMethodDocumentation;
import com.agimatec.annotations.jam.JAMAnnotation;
import com.agimatec.annotations.jam.JAMGenInstruction;
import com.agimatec.annotations.jam.JAMTestAnnotatedElement;
import com.agimatec.annotations.jam.JAMTestGenerator;
import com.agimatec.annotations.jam.JAMTestMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.codehaus.jam.JAnnotatedElement;
import org.codehaus.jam.JClass;
import org.codehaus.jam.JField;
import org.codehaus.jam.JMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAMTestClass
extends JAMTestAnnotatedElement {
    private final JClass mclass;

    public JAMTestClass(JClass mclass) {
        this.mclass = mclass;
    }

    public String getTestClassName() {
        JAMAnnotation ja = this.getTestAnnotation();
        JAMGenInstruction instruct = JAMTestGenerator.getCurrentInstruction();
        return this.stringValue(ja == null ? null : ja.getStringValue("testClass"), this.trimEnding(instruct.getPrefix() + this.getSimpleName() + instruct.getSuffix()));
    }

    private String trimEnding(String fileName) {
        int li = fileName.lastIndexOf(46);
        if (li > -1) {
            return fileName.substring(0, li);
        }
        return fileName;
    }

    public List<JAMTestMethod> getAnnotatedMethods() {
        ArrayList<JAMTestMethod> methods = new ArrayList<JAMTestMethod>();
        for (JMethod method : this.mclass.getMethods()) {
            if (method.getAnnotation(TestMethodDocumentation.class) == null) continue;
            methods.add(new JAMTestMethod(method, this));
        }
        return methods;
    }

    public JAMTestMethod getMethod(String methodName) {
        for (JMethod method : this.mclass.getMethods()) {
            if (!method.getSimpleName().equals(methodName)) continue;
            return new JAMTestMethod(method, this);
        }
        return null;
    }

    public String getSimpleName() {
        return this.mclass.getSimpleName();
    }

    @Override
    public String getName() {
        return this.mclass.getQualifiedName();
    }

    @Override
    public String getType() {
        return this.getName();
    }

    @Override
    public JClass getTypeJClass() {
        return this.mclass;
    }

    @Override
    public JAMTestClass getTestClass() {
        return this;
    }

    public String getPackageName() {
        return this.mclass.getContainingPackage().getQualifiedName();
    }

    public String getTestPackageName() {
        JAMAnnotation ja;
        String pn = JAMTestGenerator.getCurrentInstruction().getDefaultPackage();
        if (pn == null || pn.length() == 0) {
            pn = this.getPackageName();
        }
        if ((ja = this.getTestAnnotation()) == null) {
            return pn;
        }
        return this.stringValue(ja.getStringValue("testPackage"), pn);
    }

    public String getTestPackagePath() {
        return this.getTestPackageName().replace('.', '/');
    }

    @Override
    protected JAnnotatedElement element() {
        return this.mclass;
    }

    @Override
    protected String singleAnnotation() {
        return TestDocumentation.class.getName();
    }

    @Override
    protected String multiAnnotation() {
        return TestMethodDocumentation.class.getName();
    }

    @Override
    public String getType(String path) {
        if (path == null || path.length() == 0) {
            return this.getType();
        }
        StringTokenizer tokens = new StringTokenizer(path, ".");
        JField current = null;
        do {
            String each = tokens.nextToken();
            current = JAMTestClass.findField(current, each);
        } while (tokens.hasMoreTokens() && current != null);
        if (current == null) {
            return null;
        }
        return current.getType().getQualifiedName();
    }
}

