/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.annotations.jam;

import com.agimatec.annotations.DTOAttribute;
import com.agimatec.annotations.DTOAttributes;
import com.agimatec.annotations.jam.JAMDtoAnnotatedElement;
import com.agimatec.annotations.jam.JAMDtoClass;
import com.sun.javadoc.Type;
import com.sun.tools.javadoc.MethodDocImpl;
import com.sun.tools.javadoc.ParameterizedTypeImpl;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jam.JAnnotatedElement;
import org.codehaus.jam.JClass;
import org.codehaus.jam.JField;
import org.codehaus.jam.JMethod;

public class JAMDtoMethod
extends JAMDtoAnnotatedElement {
    private final JMethod jmethod;
    private final JAMDtoClass dtoClass;

    public JAMDtoMethod(JMethod jmethod, JAMDtoClass dtoClass) {
        this.jmethod = jmethod;
        this.dtoClass = dtoClass;
    }

    public JAMDtoClass getDtoClass() {
        return this.dtoClass;
    }

    public JAnnotatedElement element() {
        return this.jmethod;
    }

    protected String singleAnnotation() {
        return DTOAttribute.class.getName();
    }

    protected String multiAnnotation() {
        return DTOAttributes.class.getName();
    }

    public String getName() {
        int offset = 3;
        if (this.getType().equals("boolean") && this.jmethod.getSimpleName().startsWith("is")) {
            offset = 2;
        }
        return StringUtils.uncapitalize((String)this.jmethod.getSimpleName().substring(offset));
    }

    public String getType() {
        return this.jmethod.getReturnType().getQualifiedName();
    }

    public JClass getTypeJClass() {
        return this.jmethod.getReturnType();
    }

    public JField getTypeField(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(path, ".");
        JClass current = this.jmethod.getReturnType();
        JField field = null;
        while (tokens.hasMoreTokens() && current != null) {
            String each = tokens.nextToken();
            field = JAMDtoMethod.findField(current, each);
            current = field == null ? null : field.getType();
        }
        return field;
    }

    public String getGenericParameter() {
        return JAMDtoMethod.getGenericParameter(this.jmethod);
    }

    public static String getGenericParameter(JMethod jmethod) {
        Type[] args;
        Type type = ((MethodDocImpl)jmethod.getArtifact()).returnType();
        Object genericType = null;
        if (type instanceof ParameterizedTypeImpl && (args = ((ParameterizedTypeImpl)type).typeArguments()) != null && args.length == 1) {
            genericType = args[0];
        }
        return genericType == null ? null : genericType.toString();
    }

    public boolean isEnumType() {
        return this.jmethod.getReturnType().isEnumType();
    }
}

