/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.annotations.jam;

import com.agimatec.annotations.jam.JAMDtoClass;
import com.agimatec.annotations.jam.JAMGenInstruction;
import com.agimatec.commons.generator.FreemarkerFileGenerator;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jam.JClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAMDtoGenerator {
    private String templateDir;
    private List<JAMGenInstruction> instructions = new ArrayList<JAMGenInstruction>(2);
    private static final ThreadLocal<Collection<JAMDtoClass>> jamClasses = new ThreadLocal();
    private static final ThreadLocal<JAMGenInstruction> currentInstruction = new ThreadLocal();
    private FreemarkerFileGenerator generator;

    public String getTemplateDir() {
        return this.templateDir;
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    public String capitalize(String string) {
        return StringUtils.capitalize((String)string);
    }

    public static JAMGenInstruction getCurrentInstruction() {
        return currentInstruction.get();
    }

    public static String getCurrentEntity() {
        return JAMDtoGenerator.getCurrentInstruction().getUsageQualifier();
    }

    public static JAMDtoClass getJAMClass(String qualifiedName) {
        for (JAMDtoClass each : jamClasses.get()) {
            if (!each.getName().equals(qualifiedName)) continue;
            return each;
        }
        return null;
    }

    public JAMGenInstruction addInstruction(String templateBaseName, String outputDir, String outputFile) {
        JAMGenInstruction i = new JAMGenInstruction();
        i.setTemplate(templateBaseName + ".ftl");
        i.setOutputDir(outputDir);
        i.setOutputFile(outputFile);
        i.setPrefix("");
        i.setSuffix(".java");
        this.instructions.add(i);
        return i;
    }

    public void generate(Collection<JClass> classes) throws IOException, TemplateException {
        jamClasses.set(this.wrap(classes));
        this.generator = new FreemarkerFileGenerator(new File(this.templateDir));
        this.generator.putModel("classes", jamClasses.get());
        this.generator.putModel("service", (Object)this);
        this.generate();
    }

    private void generate() throws IOException, TemplateException {
        for (JAMGenInstruction instruction : this.instructions) {
            new File(instruction.getOutputDir()).mkdirs();
            this.setCurrentInstruction(instruction);
            this.generator.setBaseDir(instruction.getOutputDir());
            this.generator.setDestFileName(instruction.getOutputFile());
            this.generator.setTemplateName(instruction.getTemplate());
            this.generator.generate();
        }
    }

    private void setCurrentInstruction(JAMGenInstruction instruction) {
        currentInstruction.set(instruction);
    }

    private Collection<JAMDtoClass> wrap(Collection<JClass> classes) {
        ArrayList<JAMDtoClass> wrapped = new ArrayList<JAMDtoClass>(classes.size());
        for (JClass each : classes) {
            wrapped.add(new JAMDtoClass(each));
        }
        return wrapped;
    }
}

