/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.annotations.jam;

import com.agimatec.annotations.jam.JAMAnnotation;
import com.agimatec.annotations.jam.JAMDtoAnnotatedElement;
import com.agimatec.annotations.jam.JAMDtoClass;
import com.agimatec.annotations.jam.JAMDtoField;
import com.agimatec.annotations.jam.JAMDtoGenerator;
import com.agimatec.annotations.jam.JAMDtoMethod;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jam.JField;
import org.codehaus.jam.JMethod;

public class JAMDtoFieldAnnotation {
    private final JAMAnnotation annotation;
    private final JAMDtoAnnotatedElement element;
    private JAMDtoAnnotatedElement[] targetElements;

    public JAMDtoFieldAnnotation(JAMAnnotation annotation, JAMDtoField field) {
        this.annotation = annotation;
        this.element = field;
    }

    public JAMDtoFieldAnnotation(JAMAnnotation annotation, JAMDtoMethod method) {
        this.annotation = annotation;
        this.element = method;
    }

    public JAMAnnotation getAnnotation() {
        return this.annotation;
    }

    public JAMDtoField getField() {
        return (JAMDtoField)(this.element instanceof JAMDtoField ? this.element : null);
    }

    public JAMDtoAnnotatedElement getElement() {
        return this.element;
    }

    public boolean isDtoCopyByReference() {
        return this.annotation.getBooleanValue("copyByReference");
    }

    public boolean isDtoOneWay() {
        return this.annotation.getBooleanValue("oneWay");
    }

    public String getDtoConverter() {
        return this.getDtoAnnoValue("converter");
    }

    public String getDtoPath() {
        return this.getDtoAnnoValue("path");
    }

    public String getDtoAddMethod() {
        return this.getDtoAnnoValue("addMethod");
    }

    private String getDtoAnnoValue(String annoAttribute) {
        String val = this.annotation.getStringValue(annoAttribute);
        return val == null || val.length() == 0 ? null : val;
    }

    public String getDtoName() {
        String name = this.annotation.getStringValue("property");
        return name.length() == 0 ? this.element.getName() : name;
    }

    public String getDtoType() {
        String type = this.annotation.getStringValue("type");
        return type == null || type.length() == 0 ? null : type;
    }

    public JAMAnnotation findGetterAnnotation(String annotationName) {
        if (this.getElement() instanceof JAMDtoMethod) {
            return this.getElement().getAnnotation(annotationName);
        }
        JAMDtoMethod method = this.getElement().getDtoClass().findMethod(this.getGetterName());
        if (method != null) {
            return method.getAnnotation(annotationName);
        }
        return null;
    }

    public String getDtoFieldType() {
        String type;
        String dtotype = this.getDtoType();
        if (dtotype == null) {
            String gp;
            String dt;
            if (this.getDtoPath() == null) {
                dt = this.element.getType();
                gp = this.getElement().getGenericParameter();
            } else {
                JField field = this.element.getTypeField(this.getDtoPath());
                if (field == null) {
                    gp = this.element.element() instanceof JMethod ? JAMDtoMethod.getGenericParameter((JMethod)this.element.element()) : null;
                    dt = this.element.getType();
                } else {
                    gp = JAMDtoField.getGenericParameter(field);
                    dt = field.getType().getQualifiedName();
                }
            }
            type = this.toDtoType(dt, gp);
        } else {
            if (dtotype.indexOf("<") > 0) {
                int i1 = dtotype.indexOf("<");
                return dtotype.substring(0, i1 + 1) + this.optimizeType(dtotype.substring(i1 + 1));
            }
            type = dtotype;
        }
        return this.optimizeType(type);
    }

    private String toDtoType(String dt, String gp) {
        String type;
        if (gp != null) {
            JAMDtoClass jc = JAMDtoGenerator.getJAMClass(gp);
            String cn = jc != null ? this.optimizeType(jc.getDtoPackageName() + "." + jc.getDtoClassName()) : this.optimizeType(gp);
            type = dt + "<" + cn + ">";
        } else {
            JAMDtoClass jc = JAMDtoGenerator.getJAMClass(dt);
            type = jc != null ? jc.getDtoPackageName() + "." + jc.getDtoClassName() : dt;
        }
        return type;
    }

    public String getDtoBeanType() {
        String type;
        String dtotype = this.getDtoType();
        if (dtotype == null) {
            String gp = this.getTargetElement().getGenericParameter();
            if (gp != null) {
                JAMDtoClass jc = JAMDtoGenerator.getJAMClass(gp);
                String cn = jc != null ? jc.getDtoPackageName() + "." + jc.getDtoClassName() : gp;
                type = cn;
            } else {
                String dt = this.getTargetElement().getType();
                JAMDtoClass jc = JAMDtoGenerator.getJAMClass(dt);
                type = jc != null ? jc.getDtoPackageName() + "." + jc.getDtoClassName() : dt;
            }
        } else {
            if (dtotype.indexOf(60) > 0) {
                return this.extractGenericParameter(dtotype);
            }
            type = dtotype;
        }
        return type;
    }

    private String extractGenericParameter(String dtotype) {
        int i1 = dtotype.indexOf(60);
        int i2 = dtotype.lastIndexOf(62);
        if (i2 > i1) {
            return dtotype.substring(i1 + 1, i2);
        }
        return dtotype.substring(i1 + 1);
    }

    public String getHintType() {
        String gp;
        String string = gp = this.getTargetElement() != null ? this.getTargetElement().getGenericParameter() : null;
        if (gp != null) {
            return gp;
        }
        return null;
    }

    private String optimizeType(String type) {
        String myPackage = this.element.getDtoClass().getDtoPackageName() + ".";
        if (type == null) {
            return type;
        }
        if (type.lastIndexOf(46) == "java.lang".length() && type.startsWith("java.lang.")) {
            return type.substring("java.lang.".length());
        }
        if (type.lastIndexOf(46) == myPackage.length() - 1 && type.startsWith(myPackage)) {
            return type.substring(myPackage.length());
        }
        return type;
    }

    public String getGetterName() {
        return JAMDtoFieldAnnotation.getGetterName(this.getElement().getName(), this.getDtoFieldType());
    }

    public static String getGetterName(String name, String type) {
        if (type.equals("boolean")) {
            return "is" + StringUtils.capitalize((String)name);
        }
        return "get" + StringUtils.capitalize((String)name);
    }

    public boolean isNullable() {
        JAMDtoAnnotatedElement[] elements;
        for (JAMDtoAnnotatedElement each : elements = this.getTargetElements()) {
            String getter = JAMDtoFieldAnnotation.getGetterName(each.getName(), each.getType());
            JAMDtoMethod meth = each.getDtoClass().getMethod(getter);
            if (meth == null) {
                return true;
            }
            JAMAnnotation anno = meth.getAnnotation("javax.persistence.Column");
            if (anno == null) {
                anno = meth.getAnnotation("javax.persistence.JoinColumn");
            }
            if (anno != null) {
                if (!anno.getBooleanValue("nullable")) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean isUnique() {
        JAMDtoAnnotatedElement[] elements;
        for (JAMDtoAnnotatedElement each : elements = this.getTargetElements()) {
            String getter = JAMDtoFieldAnnotation.getGetterName(each.getName(), each.getType());
            JAMDtoMethod meth = each.getDtoClass().getMethod(getter);
            if (meth == null) {
                return false;
            }
            JAMAnnotation anno = meth.getAnnotation("javax.persistence.Column");
            if (anno == null) {
                anno = meth.getAnnotation("javax.persistence.JoinColumn");
            }
            if (anno != null) {
                if (anno.getBooleanValue("unique")) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public Integer getLength() {
        JAMDtoAnnotatedElement field = this.getTargetElement();
        if (field != null) {
            String getter = JAMDtoFieldAnnotation.getGetterName(field.getName(), field.getType());
            JAMDtoMethod meth = field.getDtoClass().getMethod(getter);
            if (meth == null) {
                return null;
            }
            JAMAnnotation anno = meth.getAnnotation("javax.persistence.Column");
            if (anno != null) {
                return anno.getIntValue("length");
            }
        }
        return null;
    }

    protected JAMDtoAnnotatedElement getTargetElement() {
        JAMDtoAnnotatedElement[] elements = this.getTargetElements();
        return elements[elements.length - 1];
    }

    protected JAMDtoAnnotatedElement[] getTargetElements() {
        if (this.targetElements != null) {
            return this.targetElements;
        }
        ArrayList<JAMDtoAnnotatedElement> elements = new ArrayList<JAMDtoAnnotatedElement>(2);
        elements.add(this.element);
        JAMDtoAnnotatedElement field = this.element;
        String path = this.getDtoPath();
        while (path != null) {
            int idx = path.indexOf(46);
            if (idx < 0) {
                field = new JAMDtoField(JAMDtoAnnotatedElement.findField(field.getTypeJClass(), path), new JAMDtoClass(field.getTypeJClass()));
                elements.add(field);
                path = null;
                continue;
            }
            String next = path.substring(0, idx);
            JField jf = JAMDtoAnnotatedElement.findField(field.getTypeJClass(), next);
            if (jf != null) {
                field = new JAMDtoField(jf, field.getDtoClass());
                elements.add(field);
            }
            path = path.substring(next.length() + 1);
        }
        this.targetElements = elements.toArray(new JAMDtoAnnotatedElement[elements.size()]);
        return this.targetElements;
    }

    public boolean isRelationship() {
        JAMDtoMethod meth;
        if (this.getDtoPath() != null) {
            String aName = this.getDtoPath().substring(this.getDtoPath().lastIndexOf(46) + 1);
            meth = this.getTargetElement().getDtoClass().getMethod(JAMDtoFieldAnnotation.getGetterName(aName, this.getTargetElement().getType()));
        } else {
            meth = this.getElement().getDtoClass().getMethod(this.getGetterName());
        }
        return meth != null && this.getDtoConverter() == null && (null != meth.getAnnotation("javax.persistence.OneToMany") || null != meth.getAnnotation("javax.persistence.ManyToOne") || null != meth.getAnnotation("javax.persistence.ManyToMany") || null != meth.getAnnotation("javax.persistence.OneToOne"));
    }

    public String toString() {
        return this.element + ";" + this.annotation;
    }
}

