/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.annotations.jam;

import com.agimatec.annotations.DTOAttribute;
import com.agimatec.annotations.DTOAttributes;
import com.agimatec.annotations.jam.JAMDtoAnnotatedElement;
import com.agimatec.annotations.jam.JAMDtoClass;
import com.sun.javadoc.Type;
import com.sun.tools.javadoc.FieldDocImpl;
import com.sun.tools.javadoc.ParameterizedTypeImpl;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jam.JAnnotatedElement;
import org.codehaus.jam.JClass;
import org.codehaus.jam.JField;

public class JAMDtoField
extends JAMDtoAnnotatedElement {
    private static final Log log = LogFactory.getLog(JAMDtoField.class);
    private final JField field;
    private final JAMDtoClass dtoClass;

    public JAMDtoField(JField field, JAMDtoClass dtoClass) {
        this.field = field;
        this.dtoClass = dtoClass;
        if (field == null) {
            log.error((Object)("no underlying field found: " + this), (Throwable)new NullPointerException());
        }
    }

    public JAMDtoClass getDtoClass() {
        return this.dtoClass;
    }

    public JAnnotatedElement element() {
        return this.field;
    }

    protected String singleAnnotation() {
        return DTOAttribute.class.getName();
    }

    protected String multiAnnotation() {
        return DTOAttributes.class.getName();
    }

    public boolean isEnumType() {
        return this.field.getType().isEnumType();
    }

    public String getName() {
        return this.field.getSimpleName();
    }

    public String getType() {
        return this.field.getType().getQualifiedName();
    }

    public JClass getTypeJClass() {
        return this.field.getType();
    }

    public JField getTypeField(String path) {
        if (path == null || path.length() == 0) {
            return this.field;
        }
        StringTokenizer tokens = new StringTokenizer(path, ".");
        JField current = this.field;
        while (tokens.hasMoreTokens() && current != null) {
            String each = tokens.nextToken();
            current = JAMDtoField.findField(current, each);
        }
        return current;
    }

    public String getGenericParameter() {
        return JAMDtoField.getGenericParameter(this.field);
    }

    public static String getGenericParameter(JField aField) {
        Type[] args;
        Type type;
        Object genericType = null;
        if (aField == null) {
            return null;
        }
        Object artifact = aField.getArtifact();
        if (artifact instanceof FieldDocImpl && (type = ((FieldDocImpl)artifact).type()) instanceof ParameterizedTypeImpl && (args = ((ParameterizedTypeImpl)type).typeArguments()) != null && args.length == 1) {
            genericType = args[0];
        }
        return genericType == null ? null : genericType.toString();
    }
}

