/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.annotations.jam;

import com.agimatec.annotations.DTO;
import com.agimatec.annotations.DTOs;
import com.agimatec.annotations.jam.JAMAnnotation;
import com.agimatec.annotations.jam.JAMDtoAnnotatedElement;
import com.agimatec.annotations.jam.JAMDtoField;
import com.agimatec.annotations.jam.JAMDtoFieldAnnotation;
import com.agimatec.annotations.jam.JAMDtoGenerator;
import com.agimatec.annotations.jam.JAMDtoMethod;
import com.agimatec.annotations.jam.JAMGenInstruction;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.codehaus.jam.JAnnotatedElement;
import org.codehaus.jam.JClass;
import org.codehaus.jam.JField;
import org.codehaus.jam.JMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAMDtoClass
extends JAMDtoAnnotatedElement {
    private List<JAMDtoField> fields;
    private final JClass mclass;

    public JAMDtoClass(JClass mclass) {
        this.mclass = mclass;
    }

    @Override
    public boolean isEnumType() {
        return this.mclass.isEnumType();
    }

    public String getDtoClassName() {
        JAMAnnotation ja = this.getDtoAnnotation();
        JAMGenInstruction instruct = JAMDtoGenerator.getCurrentInstruction();
        return this.stringValue(ja == null ? null : ja.getStringValue("dtoClass"), this.trimEnding(instruct.getPrefix() + this.getSimpleName() + instruct.getSuffix()));
    }

    public JAMDtoFieldAnnotation findByGetterAnnotation(String annotationName) {
        for (JAMDtoFieldAnnotation each : this.getDtoFieldAnnotations()) {
            JAMAnnotation a;
            JAMDtoMethod m = this.getMethod(each.getGetterName());
            if (m == null || (a = m.getAnnotation(annotationName)) == null) continue;
            return each;
        }
        return null;
    }

    public JAMDtoFieldAnnotation findByElementAnnotation(String annotationName) {
        for (JAMDtoFieldAnnotation each : this.getDtoFieldAnnotations()) {
            JAMAnnotation a = each.getElement().getAnnotation(annotationName);
            if (a == null) continue;
            return each;
        }
        return null;
    }

    private String trimEnding(String fileName) {
        int li = fileName.lastIndexOf(46);
        if (li > -1) {
            return fileName.substring(0, li);
        }
        return fileName;
    }

    public List<JAMDtoField> getDtoField() {
        ArrayList<JAMDtoField> dtoFields = new ArrayList<JAMDtoField>(this.getFields().size());
        for (JAMDtoField field : this.getFields()) {
            JAMAnnotation anno = field.getDtoAnnotation();
            if (anno == null) continue;
            dtoFields.add(field);
        }
        return dtoFields;
    }

    public JAMDtoMethod getMethod(String methodName) {
        for (JMethod method : this.mclass.getMethods()) {
            if (!method.getSimpleName().equals(methodName)) continue;
            return new JAMDtoMethod(method, this);
        }
        return null;
    }

    public List<JAMDtoFieldAnnotation> getDtoFieldAnnotations() {
        ArrayList<JAMDtoFieldAnnotation> dtoFields = new ArrayList<JAMDtoFieldAnnotation>(this.getFields().size() + 10);
        for (JAMDtoField field : this.getFields()) {
            JAMAnnotation[] annos = field.getDtoAnnotations();
            if (annos == null) continue;
            for (JAMAnnotation anno : annos) {
                dtoFields.add(new JAMDtoFieldAnnotation(anno, field));
            }
        }
        for (JMethod method : this.mclass.getMethods()) {
            JAMDtoMethod dtomethod = new JAMDtoMethod(method, this);
            JAMAnnotation[] annos = dtomethod.getDtoAnnotations();
            if (annos == null) continue;
            for (JAMAnnotation anno : annos) {
                dtoFields.add(new JAMDtoFieldAnnotation(anno, dtomethod));
            }
        }
        return dtoFields;
    }

    public List<JAMDtoField> getFields() {
        if (this.fields == null) {
            this.fields = new ArrayList<JAMDtoField>(this.mclass.getFields().length);
            for (JField each : this.mclass.getFields()) {
                this.fields.add(new JAMDtoField(each, this));
            }
        }
        return this.fields;
    }

    public String getSimpleName() {
        return this.mclass.getSimpleName();
    }

    @Override
    public String getName() {
        return this.mclass.getQualifiedName();
    }

    @Override
    public String getType() {
        return this.getName();
    }

    @Override
    public JClass getTypeJClass() {
        return this.mclass;
    }

    @Override
    public JAMDtoClass getDtoClass() {
        return this;
    }

    public String getPackageName() {
        return this.mclass.getContainingPackage().getQualifiedName();
    }

    public String getDtoPackageName() {
        JAMAnnotation ja;
        String pn = JAMDtoGenerator.getCurrentInstruction().getDefaultPackage();
        if (pn == null || pn.length() == 0) {
            pn = this.getPackageName();
        }
        if ((ja = this.getDtoAnnotation()) == null) {
            return pn;
        }
        return this.stringValue(ja.getStringValue("dtoPackage"), pn);
    }

    public String getDtoPackagePath() {
        return this.getDtoPackageName().replace('.', '/');
    }

    @Override
    public JAnnotatedElement element() {
        return this.mclass;
    }

    @Override
    protected String singleAnnotation() {
        return DTO.class.getName();
    }

    @Override
    protected String multiAnnotation() {
        return DTOs.class.getName();
    }

    @Override
    public JField getTypeField(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(path, ".");
        JField current = null;
        do {
            String each = tokens.nextToken();
            current = JAMDtoClass.findField(current, each);
        } while (tokens.hasMoreTokens() && current != null);
        if (current == null) {
            return null;
        }
        return current;
    }

    public JAMDtoMethod findMethod(String methodName) {
        for (JMethod method : this.mclass.getMethods()) {
            if (!method.getSimpleName().equals(methodName)) continue;
            return new JAMDtoMethod(method, this);
        }
        return null;
    }
}

