/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.annomark.example.model;

import com.agimatec.annomark.example.model.Address;
import com.agimatec.annomark.example.model.Card;
import com.agimatec.annomark.example.model.Role;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="user_core")
public class UserCore
implements Serializable {
    private long userId;
    private int version;
    private String email;
    private String mobileNumber;
    private String firstName;
    private String lastName;
    private String userIdentification;
    private Timestamp registrationTime;
    private String type;
    private String gender;
    private String localeCode;
    private String state;
    private Role role;
    private Address address;
    private List<Card> cards = new ArrayList<Card>(0);

    public void addCard(Card aCard) {
        this.cards.add(aCard);
        if (aCard != null) {
            aCard.setUserCore(this);
        }
    }

    public void removeCard(Card aCard) {
        this.cards.remove(aCard);
        aCard.setUserCore(null);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="user_id", unique=true, nullable=false)
    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    @Version
    @Column(name="version", nullable=false)
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="role_id", nullable=false)
    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    @OneToOne(optional=true, cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="address_id", nullable=true, unique=true)
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address theAddress) {
        this.address = theAddress;
    }

    @Column(name="email", length=250)
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Column(name="mobile_number", length=40)
    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    @Column(name="first_name", nullable=true, length=40)
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column(name="last_name", nullable=true, length=40)
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Column(name="user_identification", nullable=false, unique=true, length=40)
    public String getUserIdentification() {
        return this.userIdentification;
    }

    public void setUserIdentification(String userIdentification) {
        this.userIdentification = userIdentification;
    }

    @Column(name="registration_time", nullable=false, length=8)
    public Timestamp getRegistrationTime() {
        return this.registrationTime;
    }

    public void setRegistrationTime(Timestamp registrationTime) {
        this.registrationTime = registrationTime;
    }

    @Column(name="type", nullable=false, length=20)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="userCore")
    public List<Card> getCards() {
        return this.cards;
    }

    public void setCards(List<Card> cards) {
        this.cards = cards;
    }

    @Column(name="gender")
    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    @Column(name="state", nullable=false)
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Column(name="locale_code")
    public String getLocaleCode() {
        return this.localeCode;
    }

    public void setLocaleCode(String aLocaleCode) {
        this.localeCode = aLocaleCode;
    }
}

