package de.vatrasoft.vatralib;

import java.util.Arrays;

/**
 * A {@code Binding} is a component that translates abstract operations to concrete, framework-specific operations in
 * order to manipulate the screen or play sounds.
 */
public interface Binding {

    /**
     * Returns all resource file extensions (in lowercase, without dot) supported by this binding.
     *
     * @return all resource file extensions (in lowercase, without dot) supported by this binding
     */
    String[] getSupportedFileFormats();

    /**
     * Checks if the given resource file extension is supported by this binding.
     *
     * @param extension
     *         the resource file extension (without dot) to check
     * @return {@code true} if the given resource file extension is supported by this binding
     */
    default boolean isFileFormatSupported(final String extension) {
        return Arrays.stream(getSupportedFileFormats()).anyMatch(e -> e.equalsIgnoreCase(extension));
    }
}
