/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.categories.options;

import de.vandermeer.skb.base.Skb_ToStringStyle;
import de.vandermeer.skb.categories.options.Option;
import de.vandermeer.skb.categories.options.OptionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class OptionList {
    List<Option<?>> options = new ArrayList();

    public OptionList() {
    }

    public OptionList(Option<?> option) {
        if (option != null) {
            this.options.add(option);
        }
    }

    public OptionList(Collection<Option<?>> options) {
        if (options != null) {
            this.options.addAll(options);
        }
    }

    public OptionList(Option<?>[] options) {
        if (options != null) {
            for (Option<?> opt : options) {
                this.options.add(opt);
            }
        }
    }

    public OptionList addOption(Option<?> option) {
        if (option != null) {
            this.options.add(option);
        }
        return this;
    }

    public OptionList addOption(Option<?>[] options) {
        if (options != null) {
            for (Option<?> opt : options) {
                if (opt == null) continue;
                this.options.add(opt);
            }
        }
        return this;
    }

    public OptionList addOption(Collection<Option<?>> options) {
        if (options != null) {
            for (Option<?> opt : options) {
                if (opt == null) continue;
                this.options.add(opt);
            }
        }
        return this;
    }

    public boolean hasOption(Option<?> option) {
        if (option != null) {
            for (Option<?> opt : this.options) {
                if (this.options.contains(option)) {
                    return true;
                }
                if (!((String)opt.getKey()._value()).equals(option.getKey()._value())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasOption(String option) {
        for (Option<?> opt : this.options) {
            if (!((String)opt.getKey()._value()).equals(option)) continue;
            return true;
        }
        return false;
    }

    public Option<?> getOption(String option) {
        for (Option<?> opt : this.options) {
            if (!((String)opt.getKey()._value()).equals(option)) continue;
            return opt;
        }
        return null;
    }

    public Character getOptValue(String option, Character def) {
        Character ret = def;
        Option<?> opt = this.getOption(option);
        if (opt != null && opt.getValueType() == OptionType.CHARACHTER) {
            ret = (Character)opt.getValue()._value();
        }
        return ret;
    }

    public char[] getOptValue(String option, char[] def) {
        char[] ret = def;
        Option<?> opt = this.getOption(option);
        if (opt != null && opt.getValueType() == OptionType.CHARACTER_ARRAY) {
            ret = (char[])opt.getValue()._value();
        }
        return ret;
    }

    public String getOptValue(String option, String def) {
        String ret = def;
        Option<?> opt = this.getOption(option);
        if (opt != null && opt.getValueType() == OptionType.STRING) {
            ret = (String)opt.getValue()._value();
        }
        return ret;
    }

    public Boolean getOptValue(String option, Boolean def) {
        Boolean ret = def;
        Option<?> opt = this.getOption(option);
        if (opt != null && opt.getValueType() == OptionType.BOOLEAN) {
            ret = (Boolean)opt.getValue()._value();
        }
        return ret;
    }

    public Integer getOptValue(String option, Integer def) {
        Integer ret = def;
        Option<?> opt = this.getOption(option);
        if (opt != null && opt.getValueType() == OptionType.INTEGER) {
            ret = (Integer)opt.getValue()._value();
        }
        return ret;
    }

    public Double getOptValue(String option, Double def) {
        Double ret = def;
        Option<?> opt = this.getOption(option);
        if (opt != null && opt.getValueType() == OptionType.DOUBLE) {
            ret = (Double)opt.getValue()._value();
        }
        return ret;
    }

    public String toString() {
        ToStringBuilder ret = new ToStringBuilder((Object)this, Skb_ToStringStyle.TS_STYLE).append("options   ", this.options, false).append("options   ", this.options);
        return ret.toString();
    }
}

